/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.preprocessors.PermutePreprocessor;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.nd4j.common.util.ArrayUtil;

public class KerasPermute
extends KerasLayer {
    private int[] permutationIndices;

    public KerasPermute(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPermute(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        String permutationInfo = "dims";
        if (innerConfig.containsKey(permutationInfo)) {
            List targetShapeList = (List)innerConfig.get(permutationInfo);
            this.permutationIndices = ArrayUtil.toArray((List)targetShapeList);
        }
    }

    @Override
    public boolean isInputPreProcessor() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputPreProcessor getInputPreprocessor(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Permute layer accepts only one input (received " + inputType.length + ")");
        }
        PermutePreprocessor preprocessor = null;
        if (inputType[0] instanceof InputType.InputTypeConvolutional) {
            switch (this.getDimOrder()) {
                case THEANO: {
                    return new PermutePreprocessor(this.permutationIndices);
                }
                case NONE: 
                case TENSORFLOW: {
                    this.permutationIndices = new int[]{this.permutationIndices[2], this.permutationIndices[0], this.permutationIndices[1]};
                    return new PermutePreprocessor(1, 3, 2);
                }
            }
            return preprocessor;
        } else {
            if (inputType[0] instanceof InputType.InputTypeRecurrent) {
                if (!Arrays.equals(this.permutationIndices, new int[]{2, 1})) throw new InvalidKerasConfigurationException("For RNN type input data, permutation dims have to be(2, 1) in Permute layer, got " + Arrays.toString(this.permutationIndices));
                return new PermutePreprocessor(this.permutationIndices);
            }
            if (!(inputType[0] instanceof InputType.InputTypeFeedForward)) throw new InvalidKerasConfigurationException("Input type not supported: " + inputType[0]);
            return null;
        }
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Permute layer accepts only one input (received " + inputType.length + ")");
        }
        PermutePreprocessor reshape = (PermutePreprocessor)this.getInputPreprocessor(inputType);
        return reshape.getOutputType(inputType[0]);
    }
}

