/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class VocabWork
implements Serializable {
    private AtomicInteger count = new AtomicInteger(0);
    private String work;
    private boolean stem = false;
    private List<String> label;

    public VocabWork(AtomicInteger count, String work, boolean stem) {
        this(count, work, stem, "");
    }

    public VocabWork(AtomicInteger count, String work, boolean stem, String label) {
        this(count, work, stem, Arrays.asList(label));
    }

    public VocabWork(AtomicInteger count, String work, boolean stem, List<String> label) {
        this.count = count;
        this.work = work;
        this.stem = stem;
        this.label = label;
    }

    public AtomicInteger getCount() {
        return this.count;
    }

    public void setCount(AtomicInteger count) {
        this.count = count;
    }

    public String getWork() {
        return this.work;
    }

    public void setWork(String work) {
        this.work = work;
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public boolean isStem() {
        return this.stem;
    }

    public void setStem(boolean stem) {
        this.stem = stem;
    }

    public List<String> getLabel() {
        return this.label;
    }

    public void setLabel(List<String> label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VocabWork)) {
            return false;
        }
        VocabWork vocabWork = (VocabWork)o;
        if (this.stem != vocabWork.stem) {
            return false;
        }
        if (this.count != null ? !this.count.equals(vocabWork.count) : vocabWork.count != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(vocabWork.label) : vocabWork.label != null) {
            return false;
        }
        return !(this.work == null ? vocabWork.work != null : !this.work.equals(vocabWork.work));
    }

    public int hashCode() {
        int result = this.count != null ? this.count.hashCode() : 0;
        result = 31 * result + (this.work != null ? this.work.hashCode() : 0);
        result = 31 * result + (this.stem ? 1 : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }
}

