/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class FileLabelAwareIterator
implements LabelAwareIterator {
    protected List<File> files;
    protected AtomicInteger position = new AtomicInteger(0);
    protected LabelsSource labelsSource;

    protected FileLabelAwareIterator() {
    }

    protected FileLabelAwareIterator(@NonNull List<File> files, @NonNull LabelsSource source) {
        if (files == null) {
            throw new NullPointerException("files");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.files = files;
        this.labelsSource = source;
    }

    @Override
    public boolean hasNextDocument() {
        return this.position.get() < this.files.size();
    }

    @Override
    public LabelledDocument nextDocument() {
        File fileToRead = this.files.get(this.position.getAndIncrement());
        String label = fileToRead.getParentFile().getName();
        try {
            LabelledDocument document = new LabelledDocument();
            BufferedReader reader = new BufferedReader(new FileReader(fileToRead));
            StringBuilder builder = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                builder.append(line).append(" ");
            }
            reader.close();
            document.setContent(builder.toString());
            document.addLabel(label);
            try {
                reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNextDocument();
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    @Override
    public void remove() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void reset() {
        this.position.set(0);
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.labelsSource;
    }

    public static class Builder {
        protected List<File> foldersToScan = new ArrayList<File>();

        public Builder addSourceFolder(@NonNull File folder) {
            if (folder == null) {
                throw new NullPointerException("folder");
            }
            this.foldersToScan.add(folder);
            return this;
        }

        public FileLabelAwareIterator build() {
            ArrayList<File> fileList = new ArrayList<File>();
            ArrayList<String> labels = new ArrayList<String>();
            for (File file : this.foldersToScan) {
                File[] files;
                if (!file.isDirectory() || (files = file.listFiles()) == null || files.length == 0) continue;
                for (File fileLabel : files) {
                    File[] docs;
                    if (!fileLabel.isDirectory()) continue;
                    if (!labels.contains(fileLabel.getName())) {
                        labels.add(fileLabel.getName());
                    }
                    if ((docs = fileLabel.listFiles()) == null || docs.length == 0) continue;
                    for (File fileDoc : docs) {
                        if (fileDoc.isDirectory()) continue;
                        fileList.add(fileDoc);
                    }
                }
            }
            LabelsSource source = new LabelsSource(labels);
            FileLabelAwareIterator iterator = new FileLabelAwareIterator(fileList, source);
            return iterator;
        }
    }
}

