/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.huffman;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.deeplearning4j.models.sequencevectors.graph.huffman.BinaryTree;

public class GraphHuffman
implements BinaryTree {
    private final int MAX_CODE_LENGTH;
    private final long[] codes;
    private final byte[] codeLength;
    private final int[][] innerNodePathToLeaf;

    public GraphHuffman(int nVertices) {
        this(nVertices, 64);
    }

    public GraphHuffman(int nVertices, int maxCodeLength) {
        this.codes = new long[nVertices];
        this.codeLength = new byte[nVertices];
        this.innerNodePathToLeaf = new int[nVertices][0];
        this.MAX_CODE_LENGTH = maxCodeLength;
    }

    public void buildTree(int[] vertexDegree) {
        PriorityQueue<Node> pq = new PriorityQueue<Node>();
        for (int i = 0; i < vertexDegree.length; ++i) {
            pq.add(new Node(i, vertexDegree[i], null, null));
        }
        while (pq.size() > 1) {
            Node left = (Node)pq.remove();
            Node right = (Node)pq.remove();
            Node newNode = new Node(-1, left.count + right.count, left, right);
            pq.add(newNode);
        }
        Node tree = (Node)pq.remove();
        int[] innerNodePath = new int[this.MAX_CODE_LENGTH];
        this.traverse(tree, 0L, (byte)0, -1, innerNodePath, 0);
    }

    private int traverse(Node node, long codeSoFar, byte codeLengthSoFar, int innerNodeCount, int[] innerNodePath, int currDepth) {
        if (codeLengthSoFar >= this.MAX_CODE_LENGTH) {
            throw new RuntimeException("Cannot generate code: code length exceeds " + this.MAX_CODE_LENGTH + " bits");
        }
        if (node.left == null && node.right == null) {
            this.codes[((Node)node).vertexIdx] = codeSoFar;
            this.codeLength[((Node)node).vertexIdx] = codeLengthSoFar;
            this.innerNodePathToLeaf[((Node)node).vertexIdx] = Arrays.copyOf(innerNodePath, currDepth);
            return innerNodeCount;
        }
        innerNodePath[currDepth] = ++innerNodeCount;
        long codeLeft = GraphHuffman.setBit(codeSoFar, codeLengthSoFar, false);
        innerNodeCount = this.traverse(node.left, codeLeft, (byte)(codeLengthSoFar + 1), innerNodeCount, innerNodePath, currDepth + 1);
        long codeRight = GraphHuffman.setBit(codeSoFar, codeLengthSoFar, true);
        innerNodeCount = this.traverse(node.right, codeRight, (byte)(codeLengthSoFar + 1), innerNodeCount, innerNodePath, currDepth + 1);
        return innerNodeCount;
    }

    private static long setBit(long in, int bitNum, boolean value) {
        if (value) {
            return in | 1L << bitNum;
        }
        return in & (long)(~(1 << bitNum));
    }

    private static boolean getBit(long in, int bitNum) {
        long mask = 1L << bitNum;
        return (in & mask) != 0L;
    }

    @Override
    public long getCode(int vertexNum) {
        return this.codes[vertexNum];
    }

    @Override
    public int getCodeLength(int vertexNum) {
        return this.codeLength[vertexNum];
    }

    @Override
    public String getCodeString(int vertexNum) {
        long code = this.codes[vertexNum];
        int len = this.codeLength[vertexNum];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(GraphHuffman.getBit(code, i) ? "1" : "0");
        }
        return sb.toString();
    }

    public List<Integer> getCodeList(int vertexNum) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        long code = this.codes[vertexNum];
        int len = this.codeLength[vertexNum];
        for (int i = 0; i < len; ++i) {
            result.add(GraphHuffman.getBit(code, i) ? 1 : 0);
        }
        return result;
    }

    @Override
    public int[] getPathInnerNodes(int vertexNum) {
        return this.innerNodePathToLeaf[vertexNum];
    }

    private static class Node
    implements Comparable<Node> {
        private final int vertexIdx;
        private final long count;
        private Node left;
        private Node right;

        @Override
        public int compareTo(Node o) {
            return Long.compare(this.count, o.count);
        }

        public Node(int vertexIdx, long count, Node left, Node right) {
            this.vertexIdx = vertexIdx;
            this.count = count;
            this.left = left;
            this.right = right;
        }
    }
}

