/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.walkers.impl;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.deeplearning4j.models.sequencevectors.graph.enums.NoEdgeHandling;
import org.deeplearning4j.models.sequencevectors.graph.enums.WalkDirection;
import org.deeplearning4j.models.sequencevectors.graph.exception.NoEdgesException;
import org.deeplearning4j.models.sequencevectors.graph.primitives.IGraph;
import org.deeplearning4j.models.sequencevectors.graph.primitives.Vertex;
import org.deeplearning4j.models.sequencevectors.graph.walkers.GraphWalker;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomWalker<T extends SequenceElement>
implements GraphWalker<T> {
    protected int walkLength = 5;
    protected NoEdgeHandling noEdgeHandling = NoEdgeHandling.EXCEPTION_ON_DISCONNECTED;
    protected IGraph<T, ?> sourceGraph;
    protected AtomicInteger position = new AtomicInteger(0);
    protected Random rng = new Random(System.currentTimeMillis());
    protected long seed;
    protected int[] order;
    protected WalkDirection walkDirection;
    protected double alpha;
    private static final Logger logger = LoggerFactory.getLogger(RandomWalker.class);

    protected RandomWalker() {
    }

    @Override
    public boolean hasNext() {
        return this.position.get() < this.sourceGraph.numVertices();
    }

    @Override
    public boolean isLabelEnabled() {
        return false;
    }

    @Override
    public Sequence<T> next() {
        int startPoint;
        int[] visitedHops = new int[this.walkLength];
        Arrays.fill(visitedHops, -1);
        Sequence<T> sequence = new Sequence<T>();
        int startPosition = this.position.getAndIncrement();
        int lastId = -1;
        startPosition = startPoint = this.order[startPosition];
        for (int i = 0; i < this.walkLength; ++i) {
            Vertex<T> vertex = this.sourceGraph.getVertex(startPosition);
            int currentPosition = startPosition;
            sequence.addElement(vertex.getValue());
            visitedHops[i] = vertex.vertexID();
            if (this.alpha > 0.0 && lastId != startPoint && lastId != -1 && this.alpha > this.rng.nextDouble()) {
                startPosition = startPoint;
                continue;
            }
            block0 : switch (this.walkDirection) {
                case RANDOM: {
                    int[] nextHops = this.sourceGraph.getConnectedVertexIndices(currentPosition);
                    startPosition = nextHops[this.rng.nextInt(nextHops.length)];
                    break;
                }
                case FORWARD_ONLY: {
                    int[] nextHops = ArrayUtils.removeElements((int[])this.sourceGraph.getConnectedVertexIndices(currentPosition), (int[])new int[]{lastId});
                    if (nextHops.length > 0) {
                        startPosition = nextHops[this.rng.nextInt(nextHops.length)];
                        break;
                    }
                    switch (this.noEdgeHandling) {
                        case CUTOFF_ON_DISCONNECTED: {
                            i += this.walkLength;
                            break block0;
                        }
                        case EXCEPTION_ON_DISCONNECTED: {
                            throw new NoEdgesException("No more edges at vertex [" + currentPosition + "]");
                        }
                        case SELF_LOOP_ON_DISCONNECTED: {
                            startPosition = currentPosition;
                            break block0;
                        }
                        case PADDING_ON_DISCONNECTED: {
                            throw new UnsupportedOperationException("PADDING not implemented yet");
                        }
                        case RESTART_ON_DISCONNECTED: {
                            startPosition = startPoint;
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("NoEdgeHandling mode [" + (Object)((Object)this.noEdgeHandling) + "] not implemented yet.");
                }
                case FORWARD_UNIQUE: {
                    int[] nextHops = ArrayUtils.removeElements((int[])this.sourceGraph.getConnectedVertexIndices(currentPosition), (int[])visitedHops);
                    if (nextHops.length > 0) {
                        startPosition = nextHops[this.rng.nextInt(nextHops.length)];
                        break;
                    }
                    switch (this.noEdgeHandling) {
                        case CUTOFF_ON_DISCONNECTED: {
                            i += this.walkLength;
                            break block0;
                        }
                        case EXCEPTION_ON_DISCONNECTED: {
                            throw new NoEdgesException("No more edges at vertex [" + currentPosition + "]");
                        }
                        case SELF_LOOP_ON_DISCONNECTED: {
                            startPosition = currentPosition;
                            break block0;
                        }
                        case PADDING_ON_DISCONNECTED: {
                            throw new UnsupportedOperationException("PADDING not implemented yet");
                        }
                        case RESTART_ON_DISCONNECTED: {
                            startPosition = startPoint;
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("NoEdgeHandling mode [" + (Object)((Object)this.noEdgeHandling) + "] not implemented yet.");
                }
                case FORWARD_PREFERRED: {
                    int[] nextHops = ArrayUtils.removeElements((int[])this.sourceGraph.getConnectedVertexIndices(currentPosition), (int[])visitedHops);
                    if (nextHops.length != 0) break;
                    nextHops = ArrayUtils.removeElements((int[])this.sourceGraph.getConnectedVertexIndices(currentPosition), (int[])new int[]{lastId});
                    if (nextHops.length == 0) {
                        switch (this.noEdgeHandling) {
                            case CUTOFF_ON_DISCONNECTED: {
                                i += this.walkLength;
                                break block0;
                            }
                            case EXCEPTION_ON_DISCONNECTED: {
                                throw new NoEdgesException("No more edges at vertex [" + currentPosition + "]");
                            }
                            case SELF_LOOP_ON_DISCONNECTED: {
                                startPosition = currentPosition;
                                break block0;
                            }
                            case PADDING_ON_DISCONNECTED: {
                                throw new UnsupportedOperationException("PADDING not implemented yet");
                            }
                            case RESTART_ON_DISCONNECTED: {
                                startPosition = startPoint;
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException("NoEdgeHandling mode [" + (Object)((Object)this.noEdgeHandling) + "] not implemented yet.");
                    }
                    startPosition = nextHops[this.rng.nextInt(nextHops.length)];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown WalkDirection [" + (Object)((Object)this.walkDirection) + "]");
                }
            }
            lastId = vertex.vertexID();
        }
        return sequence;
    }

    @Override
    public void reset(boolean shuffle) {
        this.position.set(0);
        if (shuffle) {
            logger.trace("Calling shuffle() on entries...");
            for (int i = this.order.length - 1; i > 0; --i) {
                int j = this.rng.nextInt(i + 1);
                int temp = this.order[j];
                this.order[j] = this.order[i];
                this.order[i] = temp;
            }
        }
    }

    @Override
    public IGraph<T, ?> getSourceGraph() {
        return this.sourceGraph;
    }

    public static class Builder<T extends SequenceElement> {
        protected int walkLength = 5;
        protected NoEdgeHandling noEdgeHandling = NoEdgeHandling.RESTART_ON_DISCONNECTED;
        protected IGraph<T, ?> sourceGraph;
        protected long seed = 0L;
        protected WalkDirection walkDirection = WalkDirection.FORWARD_ONLY;
        protected double alpha;

        public Builder(@NonNull IGraph<T, ?> graph) {
            if (graph == null) {
                throw new NullPointerException("graph is marked non-null but is null");
            }
            this.sourceGraph = graph;
        }

        public Builder<T> setWalkLength(int walkLength) {
            this.walkLength = walkLength;
            return this;
        }

        public Builder<T> setNoEdgeHandling(@NonNull NoEdgeHandling handling) {
            if (handling == null) {
                throw new NullPointerException("handling is marked non-null but is null");
            }
            this.noEdgeHandling = handling;
            return this;
        }

        public Builder<T> setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder<T> setWalkDirection(@NonNull WalkDirection direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            this.walkDirection = direction;
            return this;
        }

        public Builder<T> setRestartProbability(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public RandomWalker<T> build() {
            RandomWalker walker = new RandomWalker();
            walker.noEdgeHandling = this.noEdgeHandling;
            walker.sourceGraph = this.sourceGraph;
            walker.walkLength = this.walkLength;
            walker.seed = this.seed;
            walker.walkDirection = this.walkDirection;
            walker.alpha = this.alpha;
            walker.order = new int[this.sourceGraph.numVertices()];
            for (int i = 0; i < walker.order.length; ++i) {
                walker.order[i] = i;
            }
            if (this.seed != 0L) {
                walker.rng = new Random(this.seed);
            }
            return walker;
        }
    }
}

