/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.primitives;

import java.io.Serializable;

public class Edge<T extends Number> {
    private final int from;
    private final int to;
    private final T value;
    private final boolean directed;

    public Edge(int from, int to, T value, boolean directed) {
        this.from = from;
        this.to = to;
        this.value = value;
        this.directed = directed;
    }

    public String toString() {
        return "edge(" + (this.directed ? "directed" : "undirected") + "," + this.from + (this.directed ? "->" : "--") + this.to + "," + (Serializable)(this.value != null ? this.value : "") + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)o;
        if (this.directed != e.directed) {
            return false;
        }
        if (this.directed) {
            if (this.from != e.from) {
                return false;
            }
            if (this.to != e.to) {
                return false;
            }
        } else if (this.from == e.from) {
            if (this.to != e.to) {
                return false;
            }
        } else {
            if (this.from != e.to) {
                return false;
            }
            if (this.to != e.from) {
                return false;
            }
        }
        if (this.value != null && e.value == null || this.value == null && e.value != null) {
            return false;
        }
        return this.value == null || this.value.equals(e.value);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.directed ? 1 : 0);
        result = 31 * result + this.from;
        result = 31 * result + this.to;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isDirected() {
        return this.directed;
    }
}

