/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.walkers.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Random;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.util.MathArrays;
import org.deeplearning4j.models.sequencevectors.graph.enums.NoEdgeHandling;
import org.deeplearning4j.models.sequencevectors.graph.enums.PopularityMode;
import org.deeplearning4j.models.sequencevectors.graph.enums.SpreadSpectrum;
import org.deeplearning4j.models.sequencevectors.graph.enums.WalkDirection;
import org.deeplearning4j.models.sequencevectors.graph.exception.NoEdgesException;
import org.deeplearning4j.models.sequencevectors.graph.primitives.IGraph;
import org.deeplearning4j.models.sequencevectors.graph.primitives.Vertex;
import org.deeplearning4j.models.sequencevectors.graph.walkers.GraphWalker;
import org.deeplearning4j.models.sequencevectors.graph.walkers.impl.RandomWalker;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopularityWalker<T extends SequenceElement>
extends RandomWalker<T>
implements GraphWalker<T> {
    protected PopularityMode popularityMode = PopularityMode.MAXIMUM;
    protected int spread = 10;
    protected SpreadSpectrum spectrum;
    private static final Logger logger = LoggerFactory.getLogger(PopularityWalker.class);

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public boolean isLabelEnabled() {
        return false;
    }

    @Override
    public Sequence<T> next() {
        int startPoint;
        Sequence sequence = new Sequence();
        int[] visitedHops = new int[this.walkLength];
        Arrays.fill(visitedHops, -1);
        int startPosition = this.position.getAndIncrement();
        int lastId = -1;
        startPosition = startPoint = this.order[startPosition];
        block18: for (int i = 0; i < this.walkLength; ++i) {
            Vertex vertex = this.sourceGraph.getVertex(startPosition);
            int currentPosition = startPosition;
            sequence.addElement(vertex.getValue());
            visitedHops[i] = vertex.vertexID();
            int cSpread = 0;
            if (this.alpha > 0.0 && lastId != startPoint && lastId != -1 && this.alpha > this.rng.nextDouble()) {
                startPosition = startPoint;
                continue;
            }
            switch (this.walkDirection) {
                case RANDOM: 
                case FORWARD_ONLY: 
                case FORWARD_UNIQUE: 
                case FORWARD_PREFERRED: {
                    int[] connections = ArrayUtils.removeElements((int[])this.sourceGraph.getConnectedVertexIndices(vertex.vertexID()), (int[])visitedHops);
                    PriorityQueue queue = new PriorityQueue(Math.max(10, connections.length), new NodeComparator());
                    int start = 0;
                    int stop = 0;
                    int cnt = 0;
                    if (connections.length > 0) {
                        for (int connected : connections) {
                            Node tNode = new Node(connected, this.sourceGraph.getConnectedVertices(connected).size());
                            queue.add(tNode);
                        }
                        cSpread = this.spread > connections.length ? connections.length : this.spread;
                        switch (this.popularityMode) {
                            case MAXIMUM: {
                                start = 0;
                                stop = start + cSpread - 1;
                                break;
                            }
                            case MINIMUM: {
                                start = connections.length - cSpread;
                                stop = connections.length - 1;
                                break;
                            }
                            case AVERAGE: {
                                int mid = connections.length / 2;
                                start = mid - cSpread / 2;
                                stop = mid + cSpread / 2;
                            }
                        }
                        cnt = 0;
                        ArrayList<Node> list = new ArrayList<Node>();
                        double[] weights = new double[cSpread];
                        int fcnt = 0;
                        while (!queue.isEmpty()) {
                            Node node = (Node)queue.poll();
                            if (cnt >= start && cnt <= stop) {
                                list.add(node);
                                weights[fcnt] = node.getWeight();
                                ++fcnt;
                            }
                            connections[cnt] = node.getVertexId();
                            ++cnt;
                        }
                        int con = -1;
                        block8 : switch (this.spectrum) {
                            case PLAIN: {
                                con = RandomUtils.nextInt((int)start, (int)(stop + 1));
                                Vertex nV = this.sourceGraph.getVertex(connections[con]);
                                startPosition = nV.vertexID();
                                lastId = vertex.vertexID();
                                break;
                            }
                            case PROPORTIONAL: {
                                double[] norm = MathArrays.normalizeArray((double[])weights, (double)1.0);
                                double prob = this.rng.nextDouble();
                                double floor = 0.0;
                                for (int b = 0; b < weights.length; ++b) {
                                    if (prob >= floor && prob < floor + norm[b]) {
                                        lastId = startPosition = ((Node)list.get(b)).getVertexId();
                                        break block8;
                                    }
                                    floor += norm[b];
                                }
                                break;
                            }
                        }
                        continue block18;
                    }
                    switch (this.noEdgeHandling) {
                        case EXCEPTION_ON_DISCONNECTED: {
                            throw new NoEdgesException("No more edges at vertex [" + currentPosition + "]");
                        }
                        case CUTOFF_ON_DISCONNECTED: {
                            i += this.walkLength;
                            continue block18;
                        }
                        case SELF_LOOP_ON_DISCONNECTED: {
                            startPosition = currentPosition;
                            continue block18;
                        }
                        case RESTART_ON_DISCONNECTED: {
                            startPosition = startPoint;
                            continue block18;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported noEdgeHandling: [" + this.noEdgeHandling + "]");
                }
                default: {
                    throw new UnsupportedOperationException("Unknown WalkDirection: [" + this.walkDirection + "]");
                }
            }
        }
        return sequence;
    }

    @Override
    public void reset(boolean shuffle) {
        super.reset(shuffle);
    }

    private static class Node<T extends SequenceElement>
    implements Comparable<Node<T>> {
        private int vertexId;
        private int weight = 0;

        @Override
        public int compareTo(Node<T> o) {
            return Integer.compare(this.weight, o.weight);
        }

        public Node(int vertexId, int weight) {
            this.vertexId = vertexId;
            this.weight = weight;
        }

        public int getVertexId() {
            return this.vertexId;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setVertexId(int vertexId) {
            this.vertexId = vertexId;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVertexId() != other.getVertexId()) {
                return false;
            }
            return this.getWeight() == other.getWeight();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVertexId();
            result = result * 59 + this.getWeight();
            return result;
        }

        public String toString() {
            return "PopularityWalker.Node(vertexId=" + this.getVertexId() + ", weight=" + this.getWeight() + ")";
        }
    }

    public static class Builder<T extends SequenceElement>
    extends RandomWalker.Builder<T> {
        protected PopularityMode popularityMode = PopularityMode.MAXIMUM;
        protected int spread = 10;
        protected SpreadSpectrum spectrum = SpreadSpectrum.PLAIN;

        public Builder(IGraph<T, ?> sourceGraph) {
            super(sourceGraph);
        }

        public Builder<T> setPopularityMode(@NonNull PopularityMode popularityMode) {
            if (popularityMode == null) {
                throw new NullPointerException("popularityMode is marked non-null but is null");
            }
            this.popularityMode = popularityMode;
            return this;
        }

        public Builder<T> setPopularitySpread(int topN) {
            this.spread = topN;
            return this;
        }

        public Builder<T> setSpreadSpectrum(@NonNull SpreadSpectrum spectrum) {
            if (spectrum == null) {
                throw new NullPointerException("spectrum is marked non-null but is null");
            }
            this.spectrum = spectrum;
            return this;
        }

        @Override
        public Builder<T> setNoEdgeHandling(@NonNull NoEdgeHandling handling) {
            if (handling == null) {
                throw new NullPointerException("handling is marked non-null but is null");
            }
            super.setNoEdgeHandling(handling);
            return this;
        }

        @Override
        public Builder<T> setSeed(long seed) {
            super.setSeed(seed);
            return this;
        }

        @Override
        public Builder<T> setWalkDirection(@NonNull WalkDirection direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            super.setWalkDirection(direction);
            return this;
        }

        @Override
        public Builder<T> setWalkLength(int walkLength) {
            super.setWalkLength(walkLength);
            return this;
        }

        @Override
        public Builder<T> setRestartProbability(double alpha) {
            super.setRestartProbability(alpha);
            return this;
        }

        @Override
        public PopularityWalker<T> build() {
            PopularityWalker walker = new PopularityWalker();
            walker.noEdgeHandling = this.noEdgeHandling;
            walker.sourceGraph = this.sourceGraph;
            walker.walkLength = this.walkLength;
            walker.seed = this.seed;
            walker.walkDirection = this.walkDirection;
            walker.alpha = this.alpha;
            walker.popularityMode = this.popularityMode;
            walker.spread = this.spread;
            walker.spectrum = this.spectrum;
            walker.order = new int[this.sourceGraph.numVertices()];
            for (int i = 0; i < walker.order.length; ++i) {
                walker.order[i] = i;
            }
            if (this.seed != 0L) {
                walker.rng = new Random(this.seed);
            }
            return walker;
        }
    }

    protected class NodeComparator
    implements Comparator<Node<T>> {
        protected NodeComparator() {
        }

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            return Integer.compare(o2.weight, o1.weight);
        }
    }
}

