/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.iterators;

import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class SynchronizedSequenceIterator<T extends SequenceElement>
implements SequenceIterator<T> {
    protected SequenceIterator<T> underlyingIterator;

    public SynchronizedSequenceIterator(@NonNull SequenceIterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        this.underlyingIterator = iterator;
    }

    @Override
    public synchronized boolean hasMoreSequences() {
        return this.underlyingIterator.hasMoreSequences();
    }

    @Override
    public synchronized Sequence<T> nextSequence() {
        return this.underlyingIterator.nextSequence();
    }

    @Override
    public synchronized void reset() {
        this.underlyingIterator.reset();
    }
}

