/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.deeplearning4j.text.sentenceiterator.BaseSentenceIterator;

public class LineSentenceIterator
extends BaseSentenceIterator {
    private InputStream file;
    private LineIterator iter;
    private File f;

    public LineSentenceIterator(File f) {
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("Please specify an existing file");
        }
        try {
            this.f = f;
            this.file = new BufferedInputStream(new FileInputStream(f));
            this.iter = IOUtils.lineIterator((InputStream)this.file, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String nextSentence() {
        String line = this.iter.nextLine();
        if (this.preProcessor != null) {
            line = this.preProcessor.preProcess(line);
        }
        return line;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public void reset() {
        try {
            if (this.file != null) {
                this.file.close();
            }
            if (this.iter != null) {
                this.iter.close();
            }
            this.file = new BufferedInputStream(new FileInputStream(this.f));
            this.iter = IOUtils.lineIterator((InputStream)this.file, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

