/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.loader;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class VectorsConfiguration
implements Serializable {
    private int minWordFrequency = 5;
    private double learningRate = 0.025;
    private double minLearningRate = 1.0E-4;
    private int layersSize = 200;
    private boolean useAdaGrad = false;
    private int batchSize = 512;
    private int iterations = 1;
    private int epochs = 1;
    private int window = 5;
    private long seed;
    private double negative = 0.0;
    private boolean useHierarchicSoftmax = true;
    private double sampling = 0.0;
    private int learningRateDecayWords;
    private int[] variableWindows;
    private boolean hugeModelExpected = false;
    private boolean useUnknown = false;
    private int scavengerActivationThreshold = 2000000;
    private int scavengerRetentionDelay = 3;
    private String elementsLearningAlgorithm;
    private String sequenceLearningAlgorithm;
    private String modelUtils;
    private String tokenizerFactory;
    private String tokenPreProcessor;
    private int nGram;
    private String UNK = "UNK";
    private String STOP = "STOP";
    private Collection<String> stopList = new ArrayList<String>();
    private int vocabSize;
    private boolean trainElementsVectors = true;
    private boolean trainSequenceVectors = true;
    private boolean allowParallelTokenization = false;
    private boolean preciseWeightInit = false;
    private boolean preciseMode = false;
    private static ObjectMapper mapper;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper mapper() {
        if (mapper == null) {
            Object object = lock;
            synchronized (object) {
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
                    return mapper;
                }
            }
        }
        return mapper;
    }

    public String toJson() {
        ObjectMapper mapper = VectorsConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toEncodedJson() {
        Base64 base64 = new Base64(Integer.MAX_VALUE);
        try {
            return base64.encodeAsString(this.toJson().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static VectorsConfiguration fromJson(String json) {
        ObjectMapper mapper = VectorsConfiguration.mapper();
        try {
            VectorsConfiguration ret = (VectorsConfiguration)mapper.readValue(json, VectorsConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public int getLayersSize() {
        return this.layersSize;
    }

    public boolean isUseAdaGrad() {
        return this.useAdaGrad;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getEpochs() {
        return this.epochs;
    }

    public int getWindow() {
        return this.window;
    }

    public long getSeed() {
        return this.seed;
    }

    public double getNegative() {
        return this.negative;
    }

    public boolean isUseHierarchicSoftmax() {
        return this.useHierarchicSoftmax;
    }

    public double getSampling() {
        return this.sampling;
    }

    public int getLearningRateDecayWords() {
        return this.learningRateDecayWords;
    }

    public int[] getVariableWindows() {
        return this.variableWindows;
    }

    public boolean isHugeModelExpected() {
        return this.hugeModelExpected;
    }

    public boolean isUseUnknown() {
        return this.useUnknown;
    }

    public int getScavengerActivationThreshold() {
        return this.scavengerActivationThreshold;
    }

    public int getScavengerRetentionDelay() {
        return this.scavengerRetentionDelay;
    }

    public String getElementsLearningAlgorithm() {
        return this.elementsLearningAlgorithm;
    }

    public String getSequenceLearningAlgorithm() {
        return this.sequenceLearningAlgorithm;
    }

    public String getModelUtils() {
        return this.modelUtils;
    }

    public String getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public String getTokenPreProcessor() {
        return this.tokenPreProcessor;
    }

    public int getNGram() {
        return this.nGram;
    }

    public String getUNK() {
        return this.UNK;
    }

    public String getSTOP() {
        return this.STOP;
    }

    public Collection<String> getStopList() {
        return this.stopList;
    }

    public int getVocabSize() {
        return this.vocabSize;
    }

    public boolean isTrainElementsVectors() {
        return this.trainElementsVectors;
    }

    public boolean isTrainSequenceVectors() {
        return this.trainSequenceVectors;
    }

    public boolean isAllowParallelTokenization() {
        return this.allowParallelTokenization;
    }

    public boolean isPreciseWeightInit() {
        return this.preciseWeightInit;
    }

    public boolean isPreciseMode() {
        return this.preciseMode;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public void setLayersSize(int layersSize) {
        this.layersSize = layersSize;
    }

    public void setUseAdaGrad(boolean useAdaGrad) {
        this.useAdaGrad = useAdaGrad;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setEpochs(int epochs) {
        this.epochs = epochs;
    }

    public void setWindow(int window) {
        this.window = window;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setNegative(double negative) {
        this.negative = negative;
    }

    public void setUseHierarchicSoftmax(boolean useHierarchicSoftmax) {
        this.useHierarchicSoftmax = useHierarchicSoftmax;
    }

    public void setSampling(double sampling) {
        this.sampling = sampling;
    }

    public void setLearningRateDecayWords(int learningRateDecayWords) {
        this.learningRateDecayWords = learningRateDecayWords;
    }

    public void setVariableWindows(int[] variableWindows) {
        this.variableWindows = variableWindows;
    }

    public void setHugeModelExpected(boolean hugeModelExpected) {
        this.hugeModelExpected = hugeModelExpected;
    }

    public void setUseUnknown(boolean useUnknown) {
        this.useUnknown = useUnknown;
    }

    public void setScavengerActivationThreshold(int scavengerActivationThreshold) {
        this.scavengerActivationThreshold = scavengerActivationThreshold;
    }

    public void setScavengerRetentionDelay(int scavengerRetentionDelay) {
        this.scavengerRetentionDelay = scavengerRetentionDelay;
    }

    public void setElementsLearningAlgorithm(String elementsLearningAlgorithm) {
        this.elementsLearningAlgorithm = elementsLearningAlgorithm;
    }

    public void setSequenceLearningAlgorithm(String sequenceLearningAlgorithm) {
        this.sequenceLearningAlgorithm = sequenceLearningAlgorithm;
    }

    public void setModelUtils(String modelUtils) {
        this.modelUtils = modelUtils;
    }

    public void setTokenizerFactory(String tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    public void setTokenPreProcessor(String tokenPreProcessor) {
        this.tokenPreProcessor = tokenPreProcessor;
    }

    public void setNGram(int nGram) {
        this.nGram = nGram;
    }

    public void setUNK(String UNK) {
        this.UNK = UNK;
    }

    public void setSTOP(String STOP) {
        this.STOP = STOP;
    }

    public void setStopList(Collection<String> stopList) {
        this.stopList = stopList;
    }

    public void setVocabSize(int vocabSize) {
        this.vocabSize = vocabSize;
    }

    public void setTrainElementsVectors(boolean trainElementsVectors) {
        this.trainElementsVectors = trainElementsVectors;
    }

    public void setTrainSequenceVectors(boolean trainSequenceVectors) {
        this.trainSequenceVectors = trainSequenceVectors;
    }

    public void setAllowParallelTokenization(boolean allowParallelTokenization) {
        this.allowParallelTokenization = allowParallelTokenization;
    }

    public void setPreciseWeightInit(boolean preciseWeightInit) {
        this.preciseWeightInit = preciseWeightInit;
    }

    public void setPreciseMode(boolean preciseMode) {
        this.preciseMode = preciseMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorsConfiguration)) {
            return false;
        }
        VectorsConfiguration other = (VectorsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinWordFrequency() != other.getMinWordFrequency()) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinLearningRate(), other.getMinLearningRate()) != 0) {
            return false;
        }
        if (this.getLayersSize() != other.getLayersSize()) {
            return false;
        }
        if (this.isUseAdaGrad() != other.isUseAdaGrad()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getIterations() != other.getIterations()) {
            return false;
        }
        if (this.getEpochs() != other.getEpochs()) {
            return false;
        }
        if (this.getWindow() != other.getWindow()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (Double.compare(this.getNegative(), other.getNegative()) != 0) {
            return false;
        }
        if (this.isUseHierarchicSoftmax() != other.isUseHierarchicSoftmax()) {
            return false;
        }
        if (Double.compare(this.getSampling(), other.getSampling()) != 0) {
            return false;
        }
        if (this.getLearningRateDecayWords() != other.getLearningRateDecayWords()) {
            return false;
        }
        if (this.isHugeModelExpected() != other.isHugeModelExpected()) {
            return false;
        }
        if (this.isUseUnknown() != other.isUseUnknown()) {
            return false;
        }
        if (this.getScavengerActivationThreshold() != other.getScavengerActivationThreshold()) {
            return false;
        }
        if (this.getScavengerRetentionDelay() != other.getScavengerRetentionDelay()) {
            return false;
        }
        if (this.getNGram() != other.getNGram()) {
            return false;
        }
        if (this.getVocabSize() != other.getVocabSize()) {
            return false;
        }
        if (this.isTrainElementsVectors() != other.isTrainElementsVectors()) {
            return false;
        }
        if (this.isTrainSequenceVectors() != other.isTrainSequenceVectors()) {
            return false;
        }
        if (this.isAllowParallelTokenization() != other.isAllowParallelTokenization()) {
            return false;
        }
        if (this.isPreciseWeightInit() != other.isPreciseWeightInit()) {
            return false;
        }
        if (this.isPreciseMode() != other.isPreciseMode()) {
            return false;
        }
        if (!Arrays.equals(this.getVariableWindows(), other.getVariableWindows())) {
            return false;
        }
        String this$elementsLearningAlgorithm = this.getElementsLearningAlgorithm();
        String other$elementsLearningAlgorithm = other.getElementsLearningAlgorithm();
        if (this$elementsLearningAlgorithm == null ? other$elementsLearningAlgorithm != null : !this$elementsLearningAlgorithm.equals(other$elementsLearningAlgorithm)) {
            return false;
        }
        String this$sequenceLearningAlgorithm = this.getSequenceLearningAlgorithm();
        String other$sequenceLearningAlgorithm = other.getSequenceLearningAlgorithm();
        if (this$sequenceLearningAlgorithm == null ? other$sequenceLearningAlgorithm != null : !this$sequenceLearningAlgorithm.equals(other$sequenceLearningAlgorithm)) {
            return false;
        }
        String this$modelUtils = this.getModelUtils();
        String other$modelUtils = other.getModelUtils();
        if (this$modelUtils == null ? other$modelUtils != null : !this$modelUtils.equals(other$modelUtils)) {
            return false;
        }
        String this$tokenizerFactory = this.getTokenizerFactory();
        String other$tokenizerFactory = other.getTokenizerFactory();
        if (this$tokenizerFactory == null ? other$tokenizerFactory != null : !this$tokenizerFactory.equals(other$tokenizerFactory)) {
            return false;
        }
        String this$tokenPreProcessor = this.getTokenPreProcessor();
        String other$tokenPreProcessor = other.getTokenPreProcessor();
        if (this$tokenPreProcessor == null ? other$tokenPreProcessor != null : !this$tokenPreProcessor.equals(other$tokenPreProcessor)) {
            return false;
        }
        String this$UNK = this.getUNK();
        String other$UNK = other.getUNK();
        if (this$UNK == null ? other$UNK != null : !this$UNK.equals(other$UNK)) {
            return false;
        }
        String this$STOP = this.getSTOP();
        String other$STOP = other.getSTOP();
        if (this$STOP == null ? other$STOP != null : !this$STOP.equals(other$STOP)) {
            return false;
        }
        Collection<String> this$stopList = this.getStopList();
        Collection<String> other$stopList = other.getStopList();
        return !(this$stopList == null ? other$stopList != null : !((Object)this$stopList).equals(other$stopList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinWordFrequency();
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $minLearningRate = Double.doubleToLongBits(this.getMinLearningRate());
        result = result * 59 + (int)($minLearningRate >>> 32 ^ $minLearningRate);
        result = result * 59 + this.getLayersSize();
        result = result * 59 + (this.isUseAdaGrad() ? 79 : 97);
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getIterations();
        result = result * 59 + this.getEpochs();
        result = result * 59 + this.getWindow();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        long $negative = Double.doubleToLongBits(this.getNegative());
        result = result * 59 + (int)($negative >>> 32 ^ $negative);
        result = result * 59 + (this.isUseHierarchicSoftmax() ? 79 : 97);
        long $sampling = Double.doubleToLongBits(this.getSampling());
        result = result * 59 + (int)($sampling >>> 32 ^ $sampling);
        result = result * 59 + this.getLearningRateDecayWords();
        result = result * 59 + (this.isHugeModelExpected() ? 79 : 97);
        result = result * 59 + (this.isUseUnknown() ? 79 : 97);
        result = result * 59 + this.getScavengerActivationThreshold();
        result = result * 59 + this.getScavengerRetentionDelay();
        result = result * 59 + this.getNGram();
        result = result * 59 + this.getVocabSize();
        result = result * 59 + (this.isTrainElementsVectors() ? 79 : 97);
        result = result * 59 + (this.isTrainSequenceVectors() ? 79 : 97);
        result = result * 59 + (this.isAllowParallelTokenization() ? 79 : 97);
        result = result * 59 + (this.isPreciseWeightInit() ? 79 : 97);
        result = result * 59 + (this.isPreciseMode() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getVariableWindows());
        String $elementsLearningAlgorithm = this.getElementsLearningAlgorithm();
        result = result * 59 + ($elementsLearningAlgorithm == null ? 43 : $elementsLearningAlgorithm.hashCode());
        String $sequenceLearningAlgorithm = this.getSequenceLearningAlgorithm();
        result = result * 59 + ($sequenceLearningAlgorithm == null ? 43 : $sequenceLearningAlgorithm.hashCode());
        String $modelUtils = this.getModelUtils();
        result = result * 59 + ($modelUtils == null ? 43 : $modelUtils.hashCode());
        String $tokenizerFactory = this.getTokenizerFactory();
        result = result * 59 + ($tokenizerFactory == null ? 43 : $tokenizerFactory.hashCode());
        String $tokenPreProcessor = this.getTokenPreProcessor();
        result = result * 59 + ($tokenPreProcessor == null ? 43 : $tokenPreProcessor.hashCode());
        String $UNK = this.getUNK();
        result = result * 59 + ($UNK == null ? 43 : $UNK.hashCode());
        String $STOP = this.getSTOP();
        result = result * 59 + ($STOP == null ? 43 : $STOP.hashCode());
        Collection<String> $stopList = this.getStopList();
        result = result * 59 + ($stopList == null ? 43 : ((Object)$stopList).hashCode());
        return result;
    }

    public String toString() {
        return "VectorsConfiguration(minWordFrequency=" + this.getMinWordFrequency() + ", learningRate=" + this.getLearningRate() + ", minLearningRate=" + this.getMinLearningRate() + ", layersSize=" + this.getLayersSize() + ", useAdaGrad=" + this.isUseAdaGrad() + ", batchSize=" + this.getBatchSize() + ", iterations=" + this.getIterations() + ", epochs=" + this.getEpochs() + ", window=" + this.getWindow() + ", seed=" + this.getSeed() + ", negative=" + this.getNegative() + ", useHierarchicSoftmax=" + this.isUseHierarchicSoftmax() + ", sampling=" + this.getSampling() + ", learningRateDecayWords=" + this.getLearningRateDecayWords() + ", variableWindows=" + Arrays.toString(this.getVariableWindows()) + ", hugeModelExpected=" + this.isHugeModelExpected() + ", useUnknown=" + this.isUseUnknown() + ", scavengerActivationThreshold=" + this.getScavengerActivationThreshold() + ", scavengerRetentionDelay=" + this.getScavengerRetentionDelay() + ", elementsLearningAlgorithm=" + this.getElementsLearningAlgorithm() + ", sequenceLearningAlgorithm=" + this.getSequenceLearningAlgorithm() + ", modelUtils=" + this.getModelUtils() + ", tokenizerFactory=" + this.getTokenizerFactory() + ", tokenPreProcessor=" + this.getTokenPreProcessor() + ", nGram=" + this.getNGram() + ", UNK=" + this.getUNK() + ", STOP=" + this.getSTOP() + ", stopList=" + this.getStopList() + ", vocabSize=" + this.getVocabSize() + ", trainElementsVectors=" + this.isTrainElementsVectors() + ", trainSequenceVectors=" + this.isTrainSequenceVectors() + ", allowParallelTokenization=" + this.isAllowParallelTokenization() + ", preciseWeightInit=" + this.isPreciseWeightInit() + ", preciseMode=" + this.isPreciseMode() + ")";
    }

    static {
        lock = new Object();
    }
}

