/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.nd4j.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PrefetchingSentenceIterator
implements SentenceIterator {
    private SentenceIterator sourceIterator;
    private int fetchSize;
    private AsyncIteratorReader reader;
    private SentencePreProcessor preProcessor;
    protected static final Logger log = LoggerFactory.getLogger(PrefetchingSentenceIterator.class);

    private PrefetchingSentenceIterator() {
    }

    private void init() {
        this.reader = new AsyncIteratorReader(this.sourceIterator, this.fetchSize, this.preProcessor);
        this.reader.start();
    }

    @Override
    public String nextSentence() {
        return this.reader.nextLine();
    }

    @Override
    public boolean hasNext() {
        return this.reader != null ? this.reader.hasMoreLines() : false;
    }

    @Override
    public void reset() {
        if (this.reader != null) {
            this.reader.reset();
        }
    }

    @Override
    public void finish() {
        if (this.reader != null) {
            this.reader.terminate();
        }
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    protected void finalize() throws Throwable {
        if (this.reader != null) {
            this.reader.terminate();
        }
        super.finalize();
    }

    private class AsyncIteratorReader
    extends Thread
    implements Runnable {
        private SentenceIterator iterator;
        private int fetchSize;
        private AtomicBoolean shouldTerminate = new AtomicBoolean(false);
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private SentencePreProcessor preProcessor;
        private AtomicBoolean isRunning = new AtomicBoolean(true);
        private ArrayBlockingQueue<String> buffer;

        public AsyncIteratorReader(SentenceIterator iterator, int fetchSize, SentencePreProcessor preProcessor) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.iterator = iterator;
            this.fetchSize = fetchSize;
            this.preProcessor = preProcessor;
            this.buffer = new ArrayBlockingQueue(fetchSize * 3);
            this.setName("AsyncIteratorReader thread");
        }

        @Override
        public void run() {
            while (!this.shouldTerminate.get()) {
                if (this.iterator.hasNext()) {
                    this.isRunning.set(true);
                } else {
                    ThreadUtils.uncheckedSleep((long)50L);
                }
                while (!this.shouldTerminate.get() && this.iterator.hasNext()) {
                    if (this.buffer.size() < this.fetchSize) {
                        for (int cnt = 0; !this.shouldTerminate.get() && cnt < this.fetchSize && this.iterator.hasNext(); ++cnt) {
                            try {
                                this.lock.writeLock().lock();
                                String line = this.iterator.nextSentence();
                                if (line == null) continue;
                                this.buffer.add(this.preProcessor == null ? line : this.preProcessor.preProcess(line));
                                continue;
                            }
                            finally {
                                this.lock.writeLock().unlock();
                            }
                        }
                        continue;
                    }
                    ThreadUtils.uncheckedSleep((long)10L);
                }
                this.isRunning.set(false);
            }
        }

        public String nextLine() {
            if (!this.buffer.isEmpty()) {
                return this.buffer.poll();
            }
            try {
                return this.buffer.poll(2L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean hasMoreLines() {
            if (!this.buffer.isEmpty()) {
                return true;
            }
            try {
                this.lock.readLock().lock();
                boolean bl = this.iterator.hasNext() || !this.buffer.isEmpty();
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void reset() {
            try {
                this.lock.writeLock().lock();
                this.buffer.clear();
                this.iterator.reset();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public void terminate() {
            this.shouldTerminate.set(true);
        }
    }

    public static class Builder {
        private SentenceIterator iterator;
        private int fetchSize = 10000;
        private SentencePreProcessor preProcessor;

        public Builder(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.iterator = iterator;
        }

        public Builder setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder setSentencePreProcessor(@NonNull SentencePreProcessor preProcessor) {
            if (preProcessor == null) {
                throw new NullPointerException("preProcessor is marked non-null but is null");
            }
            this.preProcessor = preProcessor;
            return this;
        }

        public PrefetchingSentenceIterator build() {
            PrefetchingSentenceIterator pre = new PrefetchingSentenceIterator();
            pre.sourceIterator = this.iterator;
            pre.fetchSize = this.fetchSize;
            pre.preProcessor = this.preProcessor;
            pre.init();
            return pre;
        }
    }
}

