/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class EarlyTerminationDataSetIterator
implements DataSetIterator {
    private DataSetIterator underlyingIterator;
    private int terminationPoint;
    private int minibatchCount = 0;

    public EarlyTerminationDataSetIterator(DataSetIterator underlyingIterator, int terminationPoint) {
        if (terminationPoint <= 0) {
            throw new IllegalArgumentException("Termination point (the number of calls to .next() or .next(num)) has to be > 0");
        }
        this.underlyingIterator = underlyingIterator;
        this.terminationPoint = terminationPoint;
    }

    public DataSet next(int num) {
        if (this.minibatchCount < this.terminationPoint) {
            ++this.minibatchCount;
            return this.underlyingIterator.next(num);
        }
        throw new RuntimeException("Calls to next have exceeded termination point.");
    }

    public int totalExamples() {
        return this.underlyingIterator.totalExamples();
    }

    public int inputColumns() {
        return this.underlyingIterator.inputColumns();
    }

    public int totalOutcomes() {
        return this.underlyingIterator.totalOutcomes();
    }

    public boolean resetSupported() {
        return this.underlyingIterator.resetSupported();
    }

    public boolean asyncSupported() {
        return this.underlyingIterator.asyncSupported();
    }

    public void reset() {
        this.minibatchCount = 0;
        this.underlyingIterator.reset();
    }

    public int batch() {
        return this.underlyingIterator.batch();
    }

    public int cursor() {
        return this.underlyingIterator.cursor();
    }

    public int numExamples() {
        return this.underlyingIterator.numExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.underlyingIterator.setPreProcessor(preProcessor);
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.underlyingIterator.getPreProcessor();
    }

    public List<String> getLabels() {
        return this.underlyingIterator.getLabels();
    }

    public boolean hasNext() {
        return this.underlyingIterator.hasNext() && this.minibatchCount < this.terminationPoint;
    }

    public DataSet next() {
        if (this.minibatchCount < this.terminationPoint) {
            ++this.minibatchCount;
            return (DataSet)this.underlyingIterator.next();
        }
        throw new RuntimeException("Calls to next have exceeded the allotted number of minibatches.");
    }

    public void remove() {
        this.underlyingIterator.remove();
    }
}

