/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.parallel;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.datasets.iterator.parallel.MultiBoolean;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.ParallelDataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.enums.InequalityHandling;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParallelDataSetIterator
implements ParallelDataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(BaseParallelDataSetIterator.class);
    protected AtomicLong counter = new AtomicLong(0L);
    protected InequalityHandling inequalityHandling;
    protected int numProducers;
    protected AtomicBoolean allDepleted = new AtomicBoolean(false);
    protected MultiBoolean states;
    protected MultiBoolean resetTracker;
    protected ThreadLocal<Integer> producerAffinity = new ThreadLocal();

    protected BaseParallelDataSetIterator(int numProducers) {
        this.states = new MultiBoolean(numProducers, true);
        this.resetTracker = new MultiBoolean(numProducers, false, true);
        this.numProducers = numProducers;
    }

    public boolean hasNext() {
        if (this.states.allFalse() || this.allDepleted.get()) {
            return false;
        }
        int curIdx = this.getCurrentProducerIndex();
        boolean hasNext = this.hasNextFor(curIdx);
        if (hasNext) {
            return true;
        }
        this.states.set(hasNext, curIdx);
        if (this.states.allFalse()) {
            return false;
        }
        switch (this.inequalityHandling) {
            case RESET: {
                this.resetTracker.set(true, curIdx);
                if (this.resetTracker.allTrue()) {
                    this.allDepleted.set(true);
                    return false;
                }
                this.reset(curIdx);
                this.hasNextFor(curIdx);
                return true;
            }
            case RELOCATE: {
                while (!hasNext) {
                    this.stepForward();
                    hasNext = this.hasNextFor(this.getCurrentProducerIndex());
                    this.states.set(hasNext, this.getCurrentProducerIndex());
                    if (!this.states.allFalse()) continue;
                    return false;
                }
                return true;
            }
            case PASS_NULL: {
                return true;
            }
            case STOP_EVERYONE: {
                return this.states.allTrue();
            }
        }
        throw new ND4JIllegalStateException("Unknown InequalityHanding option was passed in: " + this.inequalityHandling);
    }

    public DataSet next() {
        DataSet ds = this.nextFor(this.getCurrentProducerIndex());
        this.stepForward();
        return ds;
    }

    protected int getCurrentProducerIndex() {
        return (int)(this.counter.get() % (long)this.numProducers);
    }

    protected void stepForward() {
        this.counter.getAndIncrement();
    }

    public void reset() {
        for (int i = 0; i < this.numProducers; ++i) {
            this.reset(i);
        }
    }

    public void attachThread(int producer) {
        this.producerAffinity.set(producer);
    }

    public boolean hasNextFor() {
        if (this.producerAffinity.get() == null) {
            throw new ND4JIllegalStateException("attachThread(int) should be called prior to this call");
        }
        return this.hasNextFor(this.producerAffinity.get());
    }

    public DataSet nextFor() {
        if (this.producerAffinity.get() == null) {
            throw new ND4JIllegalStateException("attachThread(int) should be called prior to this call");
        }
        return this.nextFor(this.producerAffinity.get());
    }

    public abstract boolean hasNextFor(int var1);

    public abstract DataSet nextFor(int var1);

    protected abstract void reset(int var1);

    public int totalExamples() {
        return 0;
    }

    public int totalOutcomes() {
        return 0;
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public int batch() {
        return 0;
    }

    public int cursor() {
        return 0;
    }

    public int numExamples() {
        return 0;
    }

    public DataSet next(int num) {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        return 0;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        throw new UnsupportedOperationException();
    }

    public DataSetPreProcessor getPreProcessor() {
        throw new UnsupportedOperationException();
    }

    public List<String> getLabels() {
        return null;
    }

    public void remove() {
    }
}

