/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.eval.serde;

import java.io.IOException;
import org.deeplearning4j.eval.ROC;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.SerializerProvider;
import org.nd4j.shade.jackson.databind.jsontype.TypeSerializer;

public class ROCSerializer
extends JsonSerializer<ROC> {
    public void serialize(ROC roc, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (roc.isExact()) {
            roc.calculateAUC();
            roc.calculateAUCPR();
        }
        jsonGenerator.writeNumberField("thresholdSteps", roc.getThresholdSteps());
        jsonGenerator.writeNumberField("countActualPositive", roc.getCountActualPositive());
        jsonGenerator.writeNumberField("countActualNegative", roc.getCountActualNegative());
        jsonGenerator.writeObjectField("counts", roc.getCounts());
        jsonGenerator.writeNumberField("auc", roc.calculateAUC());
        jsonGenerator.writeNumberField("auprc", roc.calculateAUCPR());
        if (roc.isExact()) {
            jsonGenerator.writeObjectField("rocCurve", (Object)roc.getRocCurve());
            jsonGenerator.writeObjectField("prCurve", (Object)roc.getPrecisionRecallCurve());
        }
        jsonGenerator.writeBooleanField("isExact", roc.isExact());
        jsonGenerator.writeNumberField("exampleCount", roc.getExampleCount());
        jsonGenerator.writeBooleanField("rocRemoveRedundantPts", roc.isRocRemoveRedundantPts());
    }

    public void serializeWithType(ROC value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }
}

