/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import java.util.Arrays;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ReshapeVertex
extends GraphVertex {
    protected int[] newShape;

    public ReshapeVertex(int ... newShape) {
        this.newShape = newShape;
    }

    @Override
    public ReshapeVertex clone() {
        return new ReshapeVertex(this.newShape);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ReshapeVertex)) {
            return false;
        }
        return Arrays.equals(((ReshapeVertex)o).newShape, this.newShape);
    }

    @Override
    public int hashCode() {
        return this.newShape.hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.ReshapeVertex(graph, name, idx, this.newShape);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        switch (this.newShape.length) {
            case 2: {
                return InputType.feedForward(this.newShape[1]);
            }
            case 3: {
                return InputType.recurrent(this.newShape[1]);
            }
            case 4: {
                return InputType.convolutional(this.newShape[1], this.newShape[2], this.newShape[0]);
            }
        }
        throw new UnsupportedOperationException("Cannot infer input type for reshape array " + Arrays.toString(this.newShape));
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, ReshapeVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public int[] getNewShape() {
        return this.newShape;
    }

    public void setNewShape(int[] newShape) {
        this.newShape = newShape;
    }

    public String toString() {
        return "ReshapeVertex(newShape=" + Arrays.toString(this.getNewShape()) + ")";
    }
}

