/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import java.util.Map;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.learning.config.NoOp;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.learning.config.Sgd;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.deser.ResolvableDeserializer;
import org.nd4j.shade.jackson.databind.deser.std.StdDeserializer;

public abstract class BaseNetConfigDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    protected final JsonDeserializer<?> defaultDeserializer;

    public BaseNetConfigDeserializer(JsonDeserializer<?> defaultDeserializer, Class<T> deserializedType) {
        super(deserializedType);
        this.defaultDeserializer = defaultDeserializer;
    }

    public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected void handleUpdaterBackwardCompatibility(Layer[] layers) {
        block9: for (int i = 0; i < layers.length; ++i) {
            Layer l = layers[i];
            if (l == null || !(l instanceof BaseLayer) || ((BaseLayer)l).getIUpdater() != null) continue;
            BaseLayer bl = (BaseLayer)l;
            Updater u = bl.getUpdater();
            double lr = bl.getLearningRate();
            double eps = bl.getEpsilon();
            double rho = bl.getRho();
            switch (u) {
                case SGD: {
                    bl.setIUpdater((IUpdater)new Sgd(lr));
                    continue block9;
                }
                case ADAM: {
                    double meanDecay = bl.getAdamMeanDecay();
                    double varDecay = bl.getAdamVarDecay();
                    bl.setIUpdater((IUpdater)Adam.builder().learningRate(lr).beta1(meanDecay).beta2(varDecay).epsilon(eps).build());
                    continue block9;
                }
                case ADADELTA: {
                    bl.setIUpdater((IUpdater)new AdaDelta(rho, eps));
                    continue block9;
                }
                case NESTEROVS: {
                    Map<Integer, Double> momentumSchedule = bl.getMomentumSchedule();
                    double momentum = bl.getMomentum();
                    bl.setIUpdater((IUpdater)new Nesterovs(lr, momentum, momentumSchedule));
                    continue block9;
                }
                case ADAGRAD: {
                    bl.setIUpdater((IUpdater)new AdaGrad(lr, eps));
                    continue block9;
                }
                case RMSPROP: {
                    double rmsDecay = bl.getRmsDecay();
                    bl.setIUpdater((IUpdater)new RmsProp(lr, rmsDecay, eps));
                    continue block9;
                }
                case NONE: {
                    bl.setIUpdater((IUpdater)new NoOp());
                    continue block9;
                }
            }
        }
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }
}

