/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class ShiftVertex
extends BaseGraphVertex {
    private double shiftFactor;

    public ShiftVertex(ComputationGraph graph, String name, int vertexIndex, double shiftFactor) {
        this(graph, name, vertexIndex, null, null, shiftFactor);
    }

    public ShiftVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, double shiftFactor) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.shiftFactor = shiftFactor;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set (ShiftVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        if (this.inputs.length > 1) {
            throw new IllegalArgumentException("ShiftVertex (name " + this.vertexName + " idx " + this.vertexIndex + ") only supports 1 input.");
        }
        INDArray shifted = this.inputs[0].dup();
        shifted.addi((Number)this.shiftFactor);
        return shifted;
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set (ShiftVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        return new Pair(null, (Object)new INDArray[]{this.epsilon.addi((Number)0)});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here (ShiftVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
    }

    @Override
    public String toString() {
        return "ShiftVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",shiftFactor=" + this.shiftFactor + ")";
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }
}

