/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.embedding;

import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddingLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.EmbeddingLayer> {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingLayer.class);

    public EmbeddingLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray z = this.preOutput(this.input);
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).getActivationFn().backprop(z, epsilon).getFirst();
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray);
        }
        INDArray weightGradients = (INDArray)this.gradientViews.get("W");
        weightGradients.assign((Number)0);
        int[] indexes = new int[this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
            weightGradients.getRow(indexes[i]).addi(delta.getRow(i));
        }
        INDArray biasGradientsView = (INDArray)this.gradientViews.get("b");
        delta.sum(biasGradientsView, new int[]{0});
        DefaultGradient ret = new DefaultGradient();
        ret.gradientForVariable().put("W", weightGradients);
        ret.gradientForVariable().put("b", biasGradientsView);
        return new Pair((Object)ret, null);
    }

    @Override
    public INDArray preOutput(boolean training) {
        if (this.input.columns() != 1) {
            throw new DL4JInvalidInputException("Cannot do forward pass for embedding layer with input more than one column. Expected input shape: [numExamples,1] with each entry being an integer index " + this.layerId());
        }
        int[] indexes = new int[this.input.length()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.input.getInt(new int[]{i, 0});
        }
        INDArray weights = this.getParam("W");
        INDArray bias = this.getParam("b");
        INDArray rows = Nd4j.pullRows((INDArray)weights, (int)1, (int[])indexes);
        rows.addiRowVector(bias);
        return rows;
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray rows = this.preOutput(training);
        INDArray ret = ((org.deeplearning4j.nn.conf.layers.EmbeddingLayer)this.layerConf()).getActivationFn().getActivation(rows, training);
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray);
        }
        return ret;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    protected void applyDropOutIfNecessary(boolean training) {
        throw new UnsupportedOperationException("Dropout not supported with EmbeddingLayer " + this.layerId());
    }
}

