/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distributions;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class DefaultParamInitializer
implements ParamInitializer {
    private static final DefaultParamInitializer INSTANCE = new DefaultParamInitializer();
    public static final String WEIGHT_KEY = "W";
    public static final String BIAS_KEY = "b";

    public static DefaultParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public int numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public int numParams(Layer l) {
        FeedForwardLayer layerConf = (FeedForwardLayer)l;
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        return nIn * nOut + nOut;
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        if (!(conf.getLayer() instanceof FeedForwardLayer)) {
            throw new IllegalArgumentException("unsupported layer type: " + conf.getLayer().getClass().getName());
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        int length = this.numParams(conf);
        if (paramsView.length() != length) {
            throw new IllegalStateException("Expected params view of length " + length + ", got length " + paramsView.length());
        }
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        int nWeightParams = nIn * nOut;
        INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nWeightParams)});
        INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nWeightParams, (int)(nWeightParams + nOut))});
        params.put(WEIGHT_KEY, this.createWeightMatrix(conf, weightView, initializeParams));
        params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
        conf.addVariable(WEIGHT_KEY);
        conf.addVariable(BIAS_KEY);
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        int nWeightParams = nIn * nOut;
        INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nWeightParams)}).reshape('f', nIn, nOut);
        INDArray biasView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nWeightParams, (int)(nWeightParams + nOut))});
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        out.put(WEIGHT_KEY, weightGradientView);
        out.put(BIAS_KEY, biasView);
        return out;
    }

    protected INDArray createBias(NeuralNetConfiguration conf, INDArray biasParamView, boolean initializeParameters) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        return this.createBias(layerConf.getNOut(), layerConf.getBiasInit(), biasParamView, initializeParameters);
    }

    protected INDArray createBias(int nOut, double biasInit, INDArray biasParamView, boolean initializeParameters) {
        if (initializeParameters) {
            INDArray ret = Nd4j.valueArrayOf((int)nOut, (double)biasInit);
            biasParamView.assign(ret);
        }
        return biasParamView;
    }

    protected INDArray createWeightMatrix(NeuralNetConfiguration conf, INDArray weightParamView, boolean initializeParameters) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        if (initializeParameters) {
            Distribution dist = Distributions.createDistribution(layerConf.getDist());
            return this.createWeightMatrix(layerConf.getNIn(), layerConf.getNOut(), layerConf.getWeightInit(), dist, weightParamView, true);
        }
        return this.createWeightMatrix(layerConf.getNIn(), layerConf.getNOut(), null, null, weightParamView, false);
    }

    protected INDArray createWeightMatrix(int nIn, int nOut, WeightInit weightInit, Distribution dist, INDArray weightParamView, boolean initializeParameters) {
        int[] shape = new int[]{nIn, nOut};
        if (initializeParameters) {
            INDArray ret = WeightInitUtil.initWeights(nIn, nOut, shape, weightInit, dist, weightParamView);
            return ret;
        }
        return WeightInitUtil.reshapeWeights(shape, weightParamView);
    }
}

