/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;

public abstract class BaseUpsamplingLayer
extends NoParamLayer {
    protected int[] size;

    protected BaseUpsamplingLayer(UpsamplingBuilder builder) {
        super(builder);
        this.size = builder.size;
    }

    @Override
    public BaseUpsamplingLayer clone() {
        BaseUpsamplingLayer clone = (BaseUpsamplingLayer)super.clone();
        return clone;
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Upsampling layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    public int[] getSize() {
        return this.size;
    }

    public void setSize(int[] size) {
        this.size = size;
    }

    public BaseUpsamplingLayer() {
    }

    @Override
    public String toString() {
        return "BaseUpsamplingLayer(super=" + super.toString() + ", size=" + Arrays.toString(this.getSize()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseUpsamplingLayer)) {
            return false;
        }
        BaseUpsamplingLayer other = (BaseUpsamplingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getSize(), other.getSize());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseUpsamplingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getSize());
        return result;
    }

    protected static abstract class UpsamplingBuilder<T extends UpsamplingBuilder<T>>
    extends Layer.Builder<T> {
        protected int[] size = new int[]{1};

        protected UpsamplingBuilder(int size) {
            this.setSize(new int[]{size});
        }

        protected UpsamplingBuilder(int[] size) {
            this.setSize(size);
        }

        public UpsamplingBuilder() {
        }

        public int[] getSize() {
            return this.size;
        }

        public void setSize(int[] size) {
            this.size = size;
        }
    }
}

