/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.convolution.Deconvolution3DLayer;
import org.deeplearning4j.nn.params.Deconvolution3DParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Deconvolution3D
extends ConvolutionLayer {
    private Convolution3D.DataFormat dataFormat = Convolution3D.DataFormat.NCDHW;

    protected Deconvolution3D(Builder builder) {
        super(builder);
        this.dataFormat = builder.dataFormat;
        this.initializeConstraints(builder);
    }

    @Override
    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public Deconvolution3D clone() {
        Deconvolution3D clone = (Deconvolution3D)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("Deconvolution2D", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        Deconvolution3DLayer ret = new Deconvolution3DLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return Deconvolution3DParamInitializer.getInstance();
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Deconvolution3D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Deconvolution 3D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN3D input, got " + inputType);
        }
        if (this.nIn <= 0L || override) {
            InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
            this.nIn = c.getChannels();
        }
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Deconvolution layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeDeconv3dLayer(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.dataFormat, this.nOut, layerIndex, this.getLayerName(), Deconvolution3DLayer.class);
    }

    public Convolution3D.DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(Convolution3D.DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Deconvolution3D() {
    }

    @Override
    public String toString() {
        return "Deconvolution3D(super=" + super.toString() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deconvolution3D)) {
            return false;
        }
        Deconvolution3D other = (Deconvolution3D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Convolution3D.DataFormat this$dataFormat = this.getDataFormat();
        Convolution3D.DataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Deconvolution3D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Convolution3D.DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        private Convolution3D.DataFormat dataFormat = Convolution3D.DataFormat.NCDHW;

        public Builder() {
            super(new int[]{2, 2, 2}, new int[]{1, 1, 1}, new int[]{0, 0, 0}, new int[]{1, 1, 1}, 3);
        }

        @Override
        protected boolean allowCausal() {
            return false;
        }

        @Override
        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            return (Builder)super.convolutionMode(convolutionMode);
        }

        @Override
        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        @Override
        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        @Override
        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate3NonNegative(kernelSize, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate3NonNegative(stride, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate3NonNegative(padding, "padding");
        }

        @Override
        public void setDilation(int ... dilation) {
            this.dilation = ValidationUtils.validate3NonNegative(dilation, "dilation");
        }

        public Builder dataFormat(Convolution3D.DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public Deconvolution3D build() {
            return new Deconvolution3D(this);
        }
    }
}

