/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.samediff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.conf.layers.samediff.SDVertexParams;
import org.deeplearning4j.nn.conf.layers.samediff.SameDiffVertex;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.layers.samediff.DL4JSameDiffMemoryMgr;
import org.deeplearning4j.nn.params.SameDiffParamInitializer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.array.SingleThreadArrayHolder;
import org.nd4j.autodiff.samediff.internal.InferenceSession;
import org.nd4j.autodiff.samediff.internal.SessionMemMgr;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.ExternalErrorsFunction;
import org.nd4j.linalg.factory.Nd4j;

public class SameDiffGraphVertex
extends BaseGraphVertex {
    protected SameDiffVertex config;
    protected SameDiff sameDiff;
    protected SDVariable outputVar;
    protected ExternalErrorsFunction fn;
    protected String outputKey;
    protected Map<String, SDVariable> inputVars;
    protected INDArray[] maskArrays;
    protected INDArray params;
    protected INDArray gradients;
    protected Map<String, INDArray> paramTable;
    protected Map<String, INDArray> gradTable;
    private MaskState currentMaskState;
    private int minibatchSize;

    public SameDiffGraphVertex(SameDiffVertex config, ComputationGraph graph, String name, int vertexIndex, INDArray paramsView, boolean initParams, DataType dataType) {
        super(graph, name, vertexIndex, null, null, dataType);
        this.config = config;
        SDVertexParams vp = config.getVertexParams();
        this.paramTable = SameDiffParamInitializer.getInstance().subsetAndReshape(vp.getParameterKeys(), vp.getParamShapes(), paramsView, null, config);
        if (initParams) {
            config.initializeParameters(this.paramTable);
        }
        this.params = paramsView;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        try (MemoryWorkspace ws = Nd4j.getWorkspaceManager().scopeOutOfWorkspaces();){
            if (this.sameDiff == null) {
                this.doInit();
            }
        }
        HashMap<Object, INDArray> phMap = new HashMap<Object, INDArray>();
        this.config.validateInput(this.inputs);
        for (int i = 0; i < this.inputs.length; ++i) {
            String name = this.config.getVertexParams().getInputs().get(i);
            String maskName = name + "_mask";
            phMap.put(name, this.inputs[i]);
            if (this.maskArrays != null && this.maskArrays[i] != null) {
                phMap.put(maskName, this.maskArrays[i]);
                continue;
            }
            phMap.put(maskName, SameDiffGraphVertex.createMask(this.dataType, this.inputs[i].shape()));
        }
        String wsNameWorking = workspaceMgr.getWorkspaceName(ArrayType.FF_WORKING_MEM);
        String wsNameOutput = workspaceMgr.getWorkspaceName(ArrayType.ACTIVATIONS);
        WorkspaceConfiguration confWorking = workspaceMgr.getConfiguration(ArrayType.FF_WORKING_MEM);
        WorkspaceConfiguration confOutput = workspaceMgr.getConfiguration(ArrayType.ACTIVATIONS);
        boolean actScopedOut = workspaceMgr.isScopedOut(ArrayType.ACTIVATIONS);
        Preconditions.checkState((actScopedOut || wsNameOutput != null ? 1 : 0) != 0, (String)"Activations must have a workspace or must be scoped out");
        DL4JSameDiffMemoryMgr mmgr = new DL4JSameDiffMemoryMgr(wsNameWorking, wsNameOutput, confWorking, confOutput);
        InferenceSession is = (InferenceSession)this.sameDiff.getSessions().get(Thread.currentThread().getId());
        if (is == null) {
            is = SameDiff.getInferenceFactory().create(this.sameDiff);
            this.sameDiff.getSessions().put(Thread.currentThread().getId(), is);
        }
        is.setMmgr((SessionMemMgr)mmgr);
        INDArray result = this.sameDiff.outputSingle(phMap, this.outputKey);
        if (!actScopedOut && !result.data().getParentWorkspace().getId().equals(wsNameOutput)) {
            result = workspaceMgr.dup(ArrayType.ACTIVATIONS, result);
        } else if (actScopedOut && result.isAttached()) {
            result = result.detach();
        }
        this.sameDiff.clearPlaceholders(true);
        this.sameDiff.clearOpInputs();
        return workspaceMgr.dup(ArrayType.ACTIVATIONS, result);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        DefaultGradient g = new DefaultGradient();
        try (MemoryWorkspace ws = Nd4j.getWorkspaceManager().scopeOutOfWorkspaces();){
            if (this.sameDiff == null) {
                this.doInit();
            }
        }
        List<String> inputNames = this.config.getVertexParams().getInputs();
        if (!this.sameDiff.hasGradientFunction()) {
            String[] inArr = inputNames.toArray(new String[inputNames.size()]);
            this.sameDiff.createGradFunction(inArr);
        }
        this.config.validateInput(this.inputs);
        Map sessionMap = this.sameDiff.getFunction("grad").getSessions();
        if (!sessionMap.containsKey(Thread.currentThread().getId())) {
            sessionMap.put(Thread.currentThread().getId(), SameDiff.getInferenceFactory().create(this.sameDiff.getFunction("grad")));
        }
        String wsNameWorking = workspaceMgr.getWorkspaceName(ArrayType.BP_WORKING_MEM);
        String wsNameActGrad = workspaceMgr.getWorkspaceName(ArrayType.ACTIVATION_GRAD);
        WorkspaceConfiguration confWorking = workspaceMgr.getConfiguration(ArrayType.BP_WORKING_MEM);
        WorkspaceConfiguration confOutput = workspaceMgr.getConfiguration(ArrayType.ACTIVATION_GRAD);
        boolean actGradScopedOut = workspaceMgr.isScopedOut(ArrayType.ACTIVATION_GRAD);
        Preconditions.checkState((actGradScopedOut || wsNameActGrad != null ? 1 : 0) != 0, (String)"Activation gradients must have a workspace or be scoped out");
        DL4JSameDiffMemoryMgr mmgr = new DL4JSameDiffMemoryMgr(wsNameWorking, wsNameActGrad, confWorking, confOutput);
        ((InferenceSession)sessionMap.get(Thread.currentThread().getId())).setMmgr((SessionMemMgr)mmgr);
        HashMap<Object, INDArray> phMap = new HashMap<Object, INDArray>();
        List<String> inputs = this.config.getVertexParams().getInputs();
        int i = 0;
        for (String s : inputs) {
            phMap.put(s, this.inputs[i++]);
        }
        for (int j = 0; j < this.inputs.length; ++j) {
            String name = inputs.get(j);
            String maskName = name + "_mask";
            if (this.maskArrays != null && this.maskArrays[j] != null) {
                phMap.put(maskName, this.maskArrays[j]);
                continue;
            }
            phMap.put(maskName, SameDiffGraphVertex.createMask(this.dataType, this.inputs[j].shape()));
        }
        String epsName = this.fn.getGradPlaceholderName();
        phMap.put(epsName, this.epsilon);
        ArrayList<String> required = new ArrayList<String>(this.config.getVertexParams().getInputs());
        required.addAll(this.paramTable.keySet());
        Map gradsMap = this.sameDiff.calculateGradients(phMap, required);
        for (String s : this.paramTable.keySet()) {
            INDArray sdGrad = (INDArray)gradsMap.get(s);
            INDArray dl4jGrad = this.gradTable.get(s);
            dl4jGrad.assign(sdGrad);
            g.gradientForVariable().put(s, dl4jGrad);
        }
        INDArray[] dLdIns = new INDArray[inputs.size()];
        String fnName = this.fn.getGradPlaceholderName();
        for (int j = 0; j < inputs.size(); ++j) {
            String name = inputs.get(j);
            dLdIns[j] = this.sameDiff.grad(name).getArr();
            String gradName = this.sameDiff.grad(inputNames.get(j)).name();
            if (dLdIns[j] == null && fnName.equals(gradName)) {
                dLdIns[j] = this.epsilon;
            }
            if (!actGradScopedOut && !dLdIns[j].data().getParentWorkspace().getId().equals(wsNameActGrad)) {
                dLdIns[j] = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, dLdIns[j]);
                continue;
            }
            if (!actGradScopedOut || !dLdIns[j].isAttached()) continue;
            dLdIns[j] = dLdIns[j].detach();
        }
        this.sameDiff.clearPlaceholders(true);
        this.sameDiff.clearOpInputs();
        return new Pair((Object)g, (Object)dLdIns);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        SDVertexParams vp = this.config.getVertexParams();
        this.gradTable = SameDiffParamInitializer.getInstance().subsetAndReshape(vp.getParameterKeys(), vp.getParamShapes(), backpropGradientsViewArray, null, this.config);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        this.maskArrays = maskArrays;
        this.currentMaskState = currentMaskState;
        return this.config.feedForwardMaskArrays(maskArrays, currentMaskState, minibatchSize);
    }

    protected void doInit() {
        try (MemoryWorkspace ws = Nd4j.getWorkspaceManager().scopeOutOfWorkspaces();){
            Object inputShape;
            this.sameDiff = SameDiff.create();
            this.sameDiff.setArrayHolders((ArrayHolder)new SingleThreadArrayHolder(), (ArrayHolder)new SingleThreadArrayHolder(), false);
            this.inputVars = new LinkedHashMap<String, SDVariable>();
            LinkedHashMap<String, SDVariable> maskVars = new LinkedHashMap<String, SDVariable>();
            int i = 0;
            for (String s : this.config.getVertexParams().getInputs()) {
                inputShape = (long[])this.inputs[i++].shape().clone();
                INDArray maskTemp = SameDiffGraphVertex.createMask(this.dataType, (long[])inputShape);
                inputShape[0] = -1L;
                SDVariable inputVar = this.sameDiff.placeHolder(s, this.dataType, (long[])inputShape);
                this.inputVars.put(s, inputVar);
                long[] maskShape = (long[])maskTemp.shape().clone();
                maskShape[0] = -1L;
                SDVariable maskVar = this.sameDiff.placeHolder(s + "_mask", maskTemp.dataType(), maskShape);
                maskVars.put(s, maskVar);
            }
            Map<String, long[]> paramShapes = this.config.getVertexParams().getParamShapes();
            LinkedHashMap<String, SDVariable> params = new LinkedHashMap<String, SDVariable>();
            inputShape = paramShapes.keySet().iterator();
            while (inputShape.hasNext()) {
                String s = (String)inputShape.next();
                long[] ps = paramShapes.get(s);
                SDVariable v = this.sameDiff.var(s, this.dataType, ps);
                params.put(s, v);
            }
            SDVariable layerOutput = this.config.defineVertex(this.sameDiff, this.inputVars, params, maskVars);
            Preconditions.checkNotNull((Object)layerOutput, (String)"Invalid output: layer output is null");
            this.outputVar = layerOutput;
            for (Map.Entry<String, INDArray> e : this.paramTable.entrySet()) {
                this.sameDiff.associateArrayWithVariable(e.getValue(), this.sameDiff.getVariable(e.getKey()));
            }
            this.fn = SameDiffUtils.externalErrors((SameDiff)this.sameDiff, null, (SDVariable[])new SDVariable[]{layerOutput});
            this.fn.outputVariable();
            this.outputKey = this.outputVar.name();
        }
    }

    @Override
    public void clearVertex() {
        this.clear();
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropOnly) {
        return this.paramTable;
    }

    @Override
    public TrainingConfig getConfig() {
        return this.config;
    }

    @Override
    public INDArray params() {
        return this.params;
    }

    @Override
    public INDArray getGradientsViewArray() {
        return this.gradients;
    }

    static INDArray createMask(DataType dataType, long[] shape) {
        switch (shape.length) {
            case 2: {
                return Nd4j.ones((DataType)dataType, (long[])new long[]{shape[0], 1L});
            }
            case 3: {
                return Nd4j.ones((DataType)dataType, (long[])new long[]{shape[0], shape[2]});
            }
            case 4: {
                return Nd4j.ones((DataType)dataType, (long[])new long[]{shape[0], 1L, 1L, 1L});
            }
        }
        Preconditions.throwEx((String)"Can not create all-ones-mask for given input shape %s.", (Object[])new Object[]{Arrays.toString(shape)});
        return null;
    }
}

