/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

package org.deeplearning4j.nn.api;

import org.nd4j.linalg.api.ndarray.INDArray;

import java.util.Map;

/**
 * Trainable: an interface common to Layers and GraphVertices that have trainable parameters
 *
 * @author Alex Black
 */
public interface Trainable {

    /**
     * @return Training configuration
     */
    TrainingConfig getConfig();

    /**
     * @return Number of parameters
     */
    int numParams();

    /**
     * @return 1d parameter vector
     */
    INDArray params();

    /**
     * @param backpropOnly If true: return only parameters that are not exclusively used for layerwise pretraining
     * @return Parameter table
     */
    Map<String,INDArray> paramTable(boolean backpropOnly);

    /**
     * @return 1D gradients view array
     */
    INDArray getGradientsViewArray();

}
