/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.layers.convolution.SpaceToBatch;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SpaceToBatchLayer
extends NoParamLayer {
    protected int[] blocks;
    protected int[][] padding;

    protected SpaceToBatchLayer(Builder builder) {
        super(builder);
        this.blocks = builder.blocks;
        this.padding = builder.padding;
    }

    @Override
    public SpaceToBatchLayer clone() {
        return (SpaceToBatchLayer)super.clone();
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        SpaceToBatch ret = new SpaceToBatch(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, SpaceToBatchLayer.class, inputType, outputType).standardMemory(0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional((i.getHeight() + (long)this.padding[0][0] + (long)this.padding[0][1]) / (long)this.blocks[0], (i.getWidth() + (long)this.padding[1][0] + (long)this.padding[1][1]) / (long)this.blocks[1], i.getChannels());
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for space to batch layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SpaceToBatchLayer does not contain parameters");
    }

    public int[] getBlocks() {
        return this.blocks;
    }

    public int[][] getPadding() {
        return this.padding;
    }

    public void setBlocks(int[] blocks) {
        this.blocks = blocks;
    }

    public void setPadding(int[][] padding) {
        this.padding = padding;
    }

    public SpaceToBatchLayer() {
    }

    @Override
    public String toString() {
        return "SpaceToBatchLayer(super=" + super.toString() + ", blocks=" + Arrays.toString(this.getBlocks()) + ", padding=" + Arrays.deepToString((Object[])this.getPadding()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceToBatchLayer)) {
            return false;
        }
        SpaceToBatchLayer other = (SpaceToBatchLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getBlocks(), other.getBlocks())) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getPadding(), (Object[])other.getPadding());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpaceToBatchLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getBlocks());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getPadding());
        return result;
    }

    public static class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected int[] blocks;
        protected int[][] padding;

        public Builder(int[] blocks) {
            this.blocks = blocks;
            this.padding = new int[][]{{0, 0}, {0, 0}};
        }

        public Builder(int[] blocks, int[][] padding) {
            this.blocks = blocks;
            this.padding = padding;
        }

        public T blocks(int[] blocks) {
            this.blocks = blocks;
            return (T)this;
        }

        public T padding(int[][] padding) {
            this.padding = padding;
            return (T)this;
        }

        @Override
        public T name(String layerName) {
            this.layerName = layerName;
            return (T)this;
        }

        @Override
        public SpaceToBatchLayer build() {
            return new SpaceToBatchLayer(this);
        }

        public Builder() {
        }
    }
}

