/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.dropout;

import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.random.impl.DropOutInverted;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"mask"})
public class SpatialDropout
implements IDropout {
    private double p;
    private ISchedule pSchedule;
    private transient INDArray mask;

    public SpatialDropout(double activationRetainProbability) {
        this(activationRetainProbability, null);
        if (activationRetainProbability < 0.0) {
            throw new IllegalArgumentException("Activation retain probability must be > 0. Got: " + activationRetainProbability);
        }
        if (activationRetainProbability == 0.0) {
            throw new IllegalArgumentException("Invalid probability value: Dropout with 0.0 probability of retaining activations is not supported");
        }
    }

    public SpatialDropout(ISchedule activationRetainProbabilitySchedule) {
        this(Double.NaN, activationRetainProbabilitySchedule);
    }

    protected SpatialDropout(@JsonProperty(value="p") double activationRetainProbability, @JsonProperty(value="pSchedule") ISchedule activationRetainProbabilitySchedule) {
        this.p = activationRetainProbability;
        this.pSchedule = activationRetainProbabilitySchedule;
    }

    @Override
    public INDArray applyDropout(INDArray inputActivations, INDArray output, int iteration, int epoch, LayerWorkspaceMgr workspaceMgr) {
        Preconditions.checkArgument((inputActivations.rank() == 5 || inputActivations.rank() == 4 || inputActivations.rank() == 3 ? 1 : 0) != 0, (String)"Cannot apply spatial dropout to activations of rank %s: spatial dropout can only be used for rank 3, 4 or 5 activations (input activations shape: %s)", (Object)inputActivations.rank(), (Object)inputActivations.shape());
        double currP = this.pSchedule != null ? this.pSchedule.valueAt(iteration, epoch) : this.p;
        long minibatch = inputActivations.size(0);
        long dim1 = inputActivations.size(1);
        this.mask = workspaceMgr.createUninitialized(ArrayType.INPUT, new long[]{minibatch, dim1}).assign((Number)1.0);
        Nd4j.getExecutioner().exec((RandomOp)new DropOutInverted(this.mask, currP));
        Broadcast.mul((INDArray)inputActivations, (INDArray)this.mask, (INDArray)output, (int[])new int[]{0, 1});
        return output;
    }

    @Override
    public INDArray backprop(INDArray gradAtOutput, INDArray gradAtInput, int iteration, int epoch) {
        Preconditions.checkState((this.mask != null ? 1 : 0) != 0, (String)"Cannot perform backprop: Dropout mask array is absent (already cleared?)");
        Broadcast.mul((INDArray)gradAtOutput, (INDArray)this.mask, (INDArray)gradAtInput, (int[])new int[]{0, 1});
        this.mask = null;
        return gradAtInput;
    }

    @Override
    public void clear() {
        this.mask = null;
    }

    @Override
    public IDropout clone() {
        return new SpatialDropout(this.p, this.pSchedule);
    }

    public double getP() {
        return this.p;
    }

    public ISchedule getPSchedule() {
        return this.pSchedule;
    }

    public INDArray getMask() {
        return this.mask;
    }

    public void setP(double p) {
        this.p = p;
    }

    public void setPSchedule(ISchedule pSchedule) {
        this.pSchedule = pSchedule;
    }

    public void setMask(INDArray mask) {
        this.mask = mask;
    }

    public String toString() {
        return "SpatialDropout(p=" + this.getP() + ", pSchedule=" + this.getPSchedule() + ", mask=" + this.getMask() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpatialDropout)) {
            return false;
        }
        SpatialDropout other = (SpatialDropout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getP(), other.getP()) != 0) {
            return false;
        }
        ISchedule this$pSchedule = this.getPSchedule();
        ISchedule other$pSchedule = other.getPSchedule();
        return !(this$pSchedule == null ? other$pSchedule != null : !this$pSchedule.equals(other$pSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpatialDropout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $p = Double.doubleToLongBits(this.getP());
        result = result * 59 + (int)($p >>> 32 ^ $p);
        ISchedule $pSchedule = this.getPSchedule();
        result = result * 59 + ($pSchedule == null ? 43 : $pSchedule.hashCode());
        return result;
    }
}

