/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;

public abstract class BaseOutputLayer
extends FeedForwardLayer {
    protected ILossFunction lossFn;
    protected boolean hasBias = true;
    protected boolean legacyBatchScaledL2 = true;

    protected BaseOutputLayer(Builder builder) {
        super(builder);
        this.lossFn = builder.lossFn;
        this.hasBias = builder.hasBias;
    }

    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType outputType = this.getOutputType(-1, inputType);
        long numParams = this.initializer().numParams(this);
        int updaterStateSize = (int)this.getIUpdater().stateSize(numParams);
        int trainSizeFixed = 0;
        int trainSizeVariable = 0;
        if (this.getIDropout() != null) {
            trainSizeVariable = (int)((long)trainSizeVariable + inputType.arrayElementsPerExample());
        }
        trainSizeVariable = (int)((long)trainSizeVariable + outputType.arrayElementsPerExample());
        return new LayerMemoryReport.Builder(this.layerName, OutputLayer.class, inputType, outputType).standardMemory(numParams, updaterStateSize).workingMemory(0L, 0L, trainSizeFixed, trainSizeVariable).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    public boolean isHasBias() {
        return this.hasBias;
    }

    public boolean isLegacyBatchScaledL2() {
        return this.legacyBatchScaledL2;
    }

    public void setLossFn(ILossFunction lossFn) {
        this.lossFn = lossFn;
    }

    public void setHasBias(boolean hasBias) {
        this.hasBias = hasBias;
    }

    public void setLegacyBatchScaledL2(boolean legacyBatchScaledL2) {
        this.legacyBatchScaledL2 = legacyBatchScaledL2;
    }

    public BaseOutputLayer() {
    }

    @Override
    public String toString() {
        return "BaseOutputLayer(super=" + super.toString() + ", lossFn=" + this.getLossFn() + ", hasBias=" + this.isHasBias() + ", legacyBatchScaledL2=" + this.isLegacyBatchScaledL2() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayer)) {
            return false;
        }
        BaseOutputLayer other = (BaseOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ILossFunction this$lossFn = this.getLossFn();
        ILossFunction other$lossFn = other.getLossFn();
        if (this$lossFn == null ? other$lossFn != null : !this$lossFn.equals(other$lossFn)) {
            return false;
        }
        if (this.isHasBias() != other.isHasBias()) {
            return false;
        }
        return this.isLegacyBatchScaledL2() == other.isLegacyBatchScaledL2();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ILossFunction $lossFn = this.getLossFn();
        result = result * 59 + ($lossFn == null ? 43 : $lossFn.hashCode());
        result = result * 59 + (this.isHasBias() ? 79 : 97);
        result = result * 59 + (this.isLegacyBatchScaledL2() ? 79 : 97);
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected ILossFunction lossFn = new LossMCXENT();
        private boolean hasBias = true;

        public Builder() {
        }

        public Builder(LossFunctions.LossFunction lossFunction) {
            this.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
        }

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(lossFunction.getILossFunction());
        }

        public T hasBias(boolean hasBias) {
            this.hasBias = hasBias;
            return (T)this;
        }

        public T lossFunction(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
            return (T)this;
        }
    }
}

