/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.util;

import java.util.Collection;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.wrapper.BaseWrapperLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class MaskZeroLayer
extends BaseWrapperLayer {
    private double maskingValue = 0.0;
    private static final long serialVersionUID = 9074525846200921839L;

    public MaskZeroLayer(Builder builder) {
        super(builder);
        this.underlying = builder.underlying;
        this.maskingValue = builder.maskValue;
    }

    public MaskZeroLayer(Layer underlying, double maskingValue) {
        this.underlying = underlying;
        this.maskingValue = maskingValue;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        NeuralNetConfiguration conf2 = conf.clone();
        conf2.setLayer(((BaseWrapperLayer)conf2.getLayer()).getUnderlying());
        org.deeplearning4j.nn.api.Layer underlyingLayer = this.underlying.instantiate(conf2, trainingListeners, layerIndex, layerParamsView, initializeParams);
        return new org.deeplearning4j.nn.layers.recurrent.MaskZeroLayer(underlyingLayer, this.maskingValue);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        return this.underlying.getOutputType(layerIndex, inputType);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        this.underlying.setNIn(inputType, override);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return this.underlying.getPreProcessorForInputType(inputType);
    }

    @Override
    public double getL1ByParam(String paramName) {
        return this.underlying.getL1ByParam(paramName);
    }

    @Override
    public double getL2ByParam(String paramName) {
        return this.underlying.getL2ByParam(paramName);
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return false;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return this.underlying.getMemoryReport(inputType);
    }

    @Override
    public String toString() {
        return "MaskZeroLayer(" + this.underlying.toString() + ")";
    }

    public double getMaskingValue() {
        return this.maskingValue;
    }

    public void setMaskingValue(double maskingValue) {
        this.maskingValue = maskingValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaskZeroLayer)) {
            return false;
        }
        MaskZeroLayer other = (MaskZeroLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMaskingValue(), other.getMaskingValue()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MaskZeroLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maskingValue = Double.doubleToLongBits(this.getMaskingValue());
        result = result * 59 + (int)($maskingValue >>> 32 ^ $maskingValue);
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private Layer underlying;
        private double maskValue;

        public Builder setUnderlying(Layer underlying) {
            this.underlying = underlying;
            return this;
        }

        public Builder setMaskValue(double maskValue) {
            this.maskValue = maskValue;
            return this;
        }

        @Override
        public MaskZeroLayer build() {
            return new MaskZeroLayer(this);
        }
    }
}

