/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.wrapper;

import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.params.WrapperLayerParamInitializer;

public abstract class BaseWrapperLayer
extends Layer {
    protected Layer underlying;

    protected BaseWrapperLayer(Layer.Builder builder) {
        super(builder);
    }

    protected BaseWrapperLayer() {
    }

    public BaseWrapperLayer(Layer underlying) {
        this.underlying = underlying;
    }

    @Override
    public ParamInitializer initializer() {
        return WrapperLayerParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        return this.underlying.getOutputType(layerIndex, inputType);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        this.underlying.setNIn(inputType, override);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        return this.underlying.getPreProcessorForInputType(inputType);
    }

    @Override
    public double getL1ByParam(String paramName) {
        return this.underlying.getL1ByParam(paramName);
    }

    @Override
    public double getL2ByParam(String paramName) {
        return this.underlying.getL2ByParam(paramName);
    }

    @Override
    public GradientNormalization getGradientNormalization() {
        return this.underlying.getGradientNormalization();
    }

    @Override
    public double getGradientNormalizationThreshold() {
        return this.underlying.getGradientNormalizationThreshold();
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        return this.underlying.isPretrainParam(paramName);
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return this.underlying.getMemoryReport(inputType);
    }

    @Override
    public void setLayerName(String layerName) {
        super.setLayerName(layerName);
        if (this.underlying != null) {
            this.underlying.setLayerName(layerName);
        }
    }

    @Override
    public boolean isPretrain() {
        return this.underlying.isPretrain();
    }

    public Layer getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(Layer underlying) {
        this.underlying = underlying;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseWrapperLayer)) {
            return false;
        }
        BaseWrapperLayer other = (BaseWrapperLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Layer this$underlying = this.getUnderlying();
        Layer other$underlying = other.getUnderlying();
        return !(this$underlying == null ? other$underlying != null : !((Object)this$underlying).equals(other$underlying));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseWrapperLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Layer $underlying = this.getUnderlying();
        result = result * 59 + ($underlying == null ? 43 : ((Object)$underlying).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseWrapperLayer(underlying=" + this.getUnderlying() + ")";
    }
}

