/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Cnn3DToFeedForwardPreProcessor
implements InputPreProcessor {
    protected long inputDepth;
    protected long inputHeight;
    protected long inputWidth;
    protected long numChannels;
    protected boolean isNCDHW = true;

    @JsonCreator
    public Cnn3DToFeedForwardPreProcessor(@JsonProperty(value="inputDepth") long inputDepth, @JsonProperty(value="inputHeight") long inputHeight, @JsonProperty(value="inputWidth") long inputWidth, @JsonProperty(value="numChannels") long numChannels, @JsonProperty(value="isNCDHW") boolean isNCDHW) {
        this.inputDepth = inputDepth;
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
        this.isNCDHW = isNCDHW;
    }

    public Cnn3DToFeedForwardPreProcessor(int inputDepth, int inputHeight, int inputWidth) {
        this.inputDepth = inputDepth;
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = 1L;
    }

    public Cnn3DToFeedForwardPreProcessor() {
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (input.rank() == 2) {
            return input;
        }
        if (this.isNCDHW && input.size(1) != this.numChannels || !this.isNCDHW && input.size(4) != this.numChannels) {
            throw new IllegalStateException("Invalid input array: expected shape in format [minibatch, channels, channels, height, width] or [minibatch, channels, height, width, channels]for numChannels: " + this.numChannels + ", inputDepth " + this.inputDepth + ", inputHeight " + this.inputHeight + " and inputWidth " + this.inputWidth + ", but got " + Arrays.toString(input.shape()));
        }
        if (!Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'c');
        }
        long[] inShape = input.shape();
        long[] outShape = new long[]{inShape[0], inShape[1] * inShape[2] * inShape[3] * inShape[4]};
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, input.reshape('c', outShape));
    }

    @Override
    public INDArray backprop(INDArray epsilons, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (!Shape.hasDefaultStridesForShape((INDArray)epsilons)) {
            epsilons = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, epsilons, 'c');
        }
        if (epsilons.rank() == 5) {
            return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilons);
        }
        if ((long)epsilons.columns() != this.inputDepth * this.inputWidth * this.inputHeight * this.numChannels) {
            throw new IllegalArgumentException("Invalid input: expect output to have depth: " + this.inputDepth + ", height: " + this.inputHeight + ", width: " + this.inputWidth + " and channels: " + this.numChannels + ", i.e. [" + epsilons.rows() + ", " + this.inputDepth * this.inputHeight * this.inputWidth * this.numChannels + "] but was instead " + Arrays.toString(epsilons.shape()));
        }
        INDArray ret = this.isNCDHW ? epsilons.reshape('c', new long[]{epsilons.size(0), this.numChannels, this.inputDepth, this.inputHeight, this.inputWidth}) : epsilons.reshape('c', new long[]{epsilons.size(0), this.inputDepth, this.inputHeight, this.inputWidth, this.numChannels});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, ret);
    }

    @Override
    public Cnn3DToFeedForwardPreProcessor clone() {
        try {
            Cnn3DToFeedForwardPreProcessor clone = (Cnn3DToFeedForwardPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input type: Expected input of type CNN3D, got " + inputType);
        }
        InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
        long outSize = c.getChannels() * c.getDepth() * c.getHeight() * c.getWidth();
        return InputType.feedForward(outSize);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    public long getInputDepth() {
        return this.inputDepth;
    }

    public long getInputHeight() {
        return this.inputHeight;
    }

    public long getInputWidth() {
        return this.inputWidth;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public boolean isNCDHW() {
        return this.isNCDHW;
    }

    public void setInputDepth(long inputDepth) {
        this.inputDepth = inputDepth;
    }

    public void setInputHeight(long inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(long inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(long numChannels) {
        this.numChannels = numChannels;
    }

    public void setNCDHW(boolean isNCDHW) {
        this.isNCDHW = isNCDHW;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cnn3DToFeedForwardPreProcessor)) {
            return false;
        }
        Cnn3DToFeedForwardPreProcessor other = (Cnn3DToFeedForwardPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputDepth() != other.getInputDepth()) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        if (this.getNumChannels() != other.getNumChannels()) {
            return false;
        }
        return this.isNCDHW() == other.isNCDHW();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cnn3DToFeedForwardPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $inputDepth = this.getInputDepth();
        result = result * 59 + (int)($inputDepth >>> 32 ^ $inputDepth);
        long $inputHeight = this.getInputHeight();
        result = result * 59 + (int)($inputHeight >>> 32 ^ $inputHeight);
        long $inputWidth = this.getInputWidth();
        result = result * 59 + (int)($inputWidth >>> 32 ^ $inputWidth);
        long $numChannels = this.getNumChannels();
        result = result * 59 + (int)($numChannels >>> 32 ^ $numChannels);
        result = result * 59 + (this.isNCDHW() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Cnn3DToFeedForwardPreProcessor(inputDepth=" + this.getInputDepth() + ", inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", isNCDHW=" + this.isNCDHW() + ")";
    }
}

