/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.GraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.graph.vertex.impl.LayerVertex;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseGraphVertex
implements GraphVertex {
    protected ComputationGraph graph;
    protected String vertexName;
    protected int vertexIndex;
    protected VertexIndices[] inputVertices;
    protected VertexIndices[] outputVertices;
    protected INDArray[] inputs;
    protected INDArray epsilon;
    protected boolean outputVertex;

    protected BaseGraphVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices) {
        this.graph = graph;
        this.vertexName = name;
        this.vertexIndex = vertexIndex;
        this.inputVertices = inputVertices;
        this.outputVertices = outputVertices;
        this.inputs = new INDArray[inputVertices != null ? inputVertices.length : 0];
    }

    @Override
    public String getVertexName() {
        return this.vertexName;
    }

    @Override
    public int getVertexIndex() {
        return this.vertexIndex;
    }

    @Override
    public int getNumInputArrays() {
        return this.inputVertices == null ? 0 : this.inputVertices.length;
    }

    @Override
    public int getNumOutputConnections() {
        return this.outputVertices == null ? 0 : this.outputVertices.length;
    }

    @Override
    public VertexIndices[] getInputVertices() {
        return this.inputVertices;
    }

    @Override
    public void setInputVertices(VertexIndices[] inputVertices) {
        this.inputVertices = inputVertices;
        this.inputs = new INDArray[inputVertices != null ? inputVertices.length : 0];
    }

    @Override
    public VertexIndices[] getOutputVertices() {
        return this.outputVertices;
    }

    @Override
    public void setOutputVertices(VertexIndices[] outputVertices) {
        this.outputVertices = outputVertices;
    }

    @Override
    public boolean isInputVertex() {
        return false;
    }

    @Override
    public void setInput(int inputNumber, INDArray input, LayerWorkspaceMgr workspaceMgr) {
        if (inputNumber >= this.getNumInputArrays()) {
            throw new IllegalArgumentException("Invalid input number");
        }
        this.inputs[inputNumber] = input;
    }

    @Override
    public void setEpsilon(INDArray epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = null;
        }
        this.epsilon = null;
        if (this.getLayer() != null) {
            this.getLayer().clear();
        }
    }

    @Override
    public boolean canDoForward() {
        for (INDArray input : this.inputs) {
            if (input != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDoBackward() {
        for (INDArray input : this.inputs) {
            if (input != null) continue;
            return false;
        }
        return this.epsilon != null;
    }

    @Override
    public INDArray getEpsilon() {
        return this.epsilon;
    }

    public abstract String toString();

    @Override
    public void setLayerAsFrozen() {
        if (!(this instanceof LayerVertex)) {
            throw new IllegalArgumentException("Cannot set non layer vertices as frozen");
        }
    }

    @Override
    public void clearVertex() {
        this.clear();
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropOnly) {
        return Collections.emptyMap();
    }

    @Override
    public long numParams() {
        return this.params() == null ? 0L : this.params().length();
    }

    @Override
    public TrainingConfig getConfig() {
        return null;
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getGradientsViewArray() {
        return null;
    }

    @Override
    public boolean updaterDivideByMinibatch(String paramName) {
        if (this.hasLayer()) {
            return this.getLayer().updaterDivideByMinibatch(paramName);
        }
        return true;
    }

    public ComputationGraph getGraph() {
        return this.graph;
    }

    @Override
    public INDArray[] getInputs() {
        return this.inputs;
    }

    public void setGraph(ComputationGraph graph) {
        this.graph = graph;
    }

    public void setVertexName(String vertexName) {
        this.vertexName = vertexName;
    }

    public void setVertexIndex(int vertexIndex) {
        this.vertexIndex = vertexIndex;
    }

    @Override
    public void setInputs(INDArray[] inputs) {
        this.inputs = inputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseGraphVertex)) {
            return false;
        }
        BaseGraphVertex other = (BaseGraphVertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComputationGraph this$graph = this.getGraph();
        ComputationGraph other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !((Object)this$graph).equals(other$graph)) {
            return false;
        }
        String this$vertexName = this.getVertexName();
        String other$vertexName = other.getVertexName();
        if (this$vertexName == null ? other$vertexName != null : !this$vertexName.equals(other$vertexName)) {
            return false;
        }
        if (this.getVertexIndex() != other.getVertexIndex()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputVertices(), other.getInputVertices())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOutputVertices(), other.getOutputVertices())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
            return false;
        }
        INDArray this$epsilon = this.getEpsilon();
        INDArray other$epsilon = other.getEpsilon();
        if (this$epsilon == null ? other$epsilon != null : !this$epsilon.equals(other$epsilon)) {
            return false;
        }
        return this.isOutputVertex() == other.isOutputVertex();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseGraphVertex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComputationGraph $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        String $vertexName = this.getVertexName();
        result = result * 59 + ($vertexName == null ? 43 : $vertexName.hashCode());
        result = result * 59 + this.getVertexIndex();
        result = result * 59 + Arrays.deepHashCode(this.getInputVertices());
        result = result * 59 + Arrays.deepHashCode(this.getOutputVertices());
        result = result * 59 + Arrays.deepHashCode(this.getInputs());
        INDArray $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : $epsilon.hashCode());
        result = result * 59 + (this.isOutputVertex() ? 79 : 97);
        return result;
    }

    @Override
    public void setOutputVertex(boolean outputVertex) {
        this.outputVertex = outputVertex;
    }

    @Override
    public boolean isOutputVertex() {
        return this.outputVertex;
    }
}

