/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.Convolution3DUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class Convolution3DLayer
extends ConvolutionLayer {
    public Convolution3DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Convolution3DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] outputs;
        INDArray[] inputs;
        int[] pad;
        if (this.input.rank() != 5) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputHeight, inputWidth, inputDepth]. " + this.layerId());
        }
        INDArray weights = this.getParamWithNoise("W", true, workspaceMgr);
        Convolution3D layerConfig = (Convolution3D)this.layerConf();
        boolean isNCDHW = layerConfig.getDataFormat() == Convolution3D.DataFormat.NCDHW;
        int miniBatch = (int)this.input.size(0);
        int inD = (int)(isNCDHW ? this.input.size(2) : this.input.size(1));
        int inH = (int)(isNCDHW ? this.input.size(3) : this.input.size(2));
        int inW = (int)(isNCDHW ? this.input.size(4) : this.input.size(3));
        int outEpsChannels = (int)((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getNIn();
        int[] dilation = layerConfig.getDilation();
        int[] kernel = layerConfig.getKernelSize();
        int[] strides = layerConfig.getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, isNCDHW);
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, new int[]{inD, inH, inW}, kernel, strides, dilation);
        } else {
            pad = layerConfig.getPadding();
        }
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray outEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, new long[]{miniBatch * outEpsChannels * inD * inH * inW});
        outEpsilon = isNCDHW ? outEpsilon.reshape('c', new int[]{miniBatch, outEpsChannels, inD, inH, inW}) : outEpsilon.reshape('c', new int[]{miniBatch, inD, inH, inW, outEpsChannels});
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], this.convolutionMode == ConvolutionMode.Same ? 1 : 0, isNCDHW ? 0 : 1};
        IActivation activation = layerConfig.getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput(true, true, workspaceMgr);
        INDArray delta = (INDArray)activation.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        INDArray biasGradView = null;
        weights = weights.permute(new int[]{2, 3, 4, 1, 0});
        INDArray opWeightGradView = weightGradView.permute(new int[]{2, 3, 4, 1, 0});
        if (layerConfig.hasBias()) {
            biasGradView = (INDArray)this.gradientViews.get("b");
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            inputs = new INDArray[]{this.input, weights, bias, delta};
            outputs = new INDArray[]{outEpsilon, opWeightGradView, biasGradView};
        } else {
            inputs = new INDArray[]{this.input, weights, delta};
            outputs = new INDArray[]{outEpsilon, opWeightGradView};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"conv3dnew_bp").addInputs(inputs).addIntegerArguments(intArgs).addOutputs(outputs).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (layerConfig.hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    public INDArray preOutput(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] inputs;
        int[] pad;
        int[] outSize;
        Convolution3D layerConfig = (Convolution3D)this.layerConf();
        ConvolutionMode mode = layerConfig.getConvolutionMode();
        boolean isNCDHW = layerConfig.getDataFormat() == Convolution3D.DataFormat.NCDHW;
        INDArray weights = this.getParamWithNoise("W", training, workspaceMgr);
        if (this.input.rank() != 5) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Convolution3DLayer (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, numChannels, inputHeight, inputWidth, inputDepth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        int miniBatch = (int)this.input.size(0);
        int inputChannels = (int)(isNCDHW ? this.input.size(1) : this.input.size(4));
        int inD = (int)(isNCDHW ? this.input.size(2) : this.input.size(1));
        int inH = (int)(isNCDHW ? this.input.size(3) : this.input.size(2));
        int inW = (int)(isNCDHW ? this.input.size(4) : this.input.size(3));
        int outWeightChannels = (int)((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getNOut();
        int inWeightChannels = (int)((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getNIn();
        if (inputChannels != inWeightChannels) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            long dataInCh = isNCDHW ? this.input.size(1) : this.input.size(4);
            String df = isNCDHW ? ", dataFormat=NCDHW, [minibatch, inputChannels, depth, height, width]=" : ", dataFormat=NDHWC, [minibatch, depth, height, width, inputChannels]=";
            throw new DL4JInvalidInputException("Cannot do forward pass in Convolution3D layer (layer name = " + layerName + ", layer index = " + this.index + "): number of input array channels does not match CNN layer configuration (data input channels = " + dataInCh + df + Arrays.toString(this.input.shape()) + "; expected input channels = " + inWeightChannels + ") " + this.layerId());
        }
        int[] kernel = layerConfig.getKernelSize();
        int[] dilation = layerConfig.getDilation();
        int[] strides = layerConfig.getStride();
        if (mode == ConvolutionMode.Same) {
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, isNCDHW);
            int[] inSize = new int[]{inD, inH, inW};
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, inSize, kernel, strides, dilation);
        } else {
            pad = layerConfig.getPadding();
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation, isNCDHW);
        }
        int outD = outSize[0];
        int outH = outSize[1];
        int outW = outSize[2];
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, new long[]{miniBatch * outWeightChannels * outD * outH * outW});
        output = isNCDHW ? output.reshape('c', new int[]{miniBatch, outWeightChannels, outD, outH, outW}) : output.reshape('c', new int[]{miniBatch, outD, outH, outW, outWeightChannels});
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], mode == ConvolutionMode.Same ? 1 : 0, isNCDHW ? 0 : 1};
        weights = weights.permute(new int[]{2, 3, 4, 1, 0});
        if (layerConfig.hasBias()) {
            INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
            inputs = new INDArray[]{this.input, weights, bias};
        } else {
            inputs = new INDArray[]{this.input, weights};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"conv3dnew").addInputs(inputs).addIntegerArguments(intArgs).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }
}

