/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class Deconvolution2DLayer
extends ConvolutionLayer {
    public Deconvolution2DLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Deconvolution2DLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] opOutputs;
        INDArray[] opInputs;
        int[] pad;
        this.assertInputSet(true);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        INDArray weights = this.getParamWithNoise("W", true, workspaceMgr);
        int miniBatch = (int)this.input.size(0);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        int inDepth = (int)weights.size(0);
        int kH = (int)weights.size(2);
        int kW = (int)weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            int[] outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        INDArray outEps = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, new int[]{miniBatch, inDepth, inH, inW}, 'c');
        Integer sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        weights = weights.permute(new int[]{2, 3, 1, 0});
        INDArray weightGradViewOp = weightGradView.permute(new int[]{2, 3, 1, 0});
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            opInputs = new INDArray[]{this.input, weights, bias, delta};
            opOutputs = new INDArray[]{outEps, weightGradViewOp, biasGradView};
        } else {
            opInputs = new INDArray[]{this.input, weights, delta};
            opOutputs = new INDArray[]{outEps, weightGradViewOp};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv2d_bp").addInputs(opInputs).addIntegerArguments(args).addOutputs(opOutputs).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        return new Pair((Object)retGradient, (Object)outEps);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        int[] pad;
        int[] outSize;
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray weights = this.getParamWithNoise("W", training, workspaceMgr);
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Deconvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, layerInputDepth, inputHeight, inputWidth]." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        int inDepth = (int)weights.size(0);
        int outDepth = (int)weights.size(1);
        if (this.input.size(1) != (long)inDepth && this.input.size(3) == (long)inDepth) {
            this.input = this.input.permute(new int[]{0, 3, 1, 2});
        } else if (this.input.size(1) != (long)inDepth && this.input.size(3) != (long)inDepth) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Cannot do forward pass in Deconvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data input channels = " + this.input.size(1) + ", [minibatch,inputDepth,height,width]=" + Arrays.toString(this.input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId());
        }
        int kH = (int)weights.size(2);
        int kW = (int)weights.size(3);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)this.input.size(2), (int)this.input.size(3)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getDeconvolutionOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation);
        }
        int outH = outSize[0];
        int outW = outSize[1];
        long miniBatch = this.input.size(0);
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, new long[]{miniBatch, outDepth, outH, outW}, 'c');
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, 0};
        weights = weights.permute(new int[]{2, 3, 1, 0});
        INDArray[] opInputs = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? new INDArray[]{this.input, weights, bias} : new INDArray[]{this.input, weights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"deconv2d").addInputs(opInputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray ret;
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        if (this.helper != null && Shape.strideDescendingCAscendingF((INDArray)z) && (ret = this.helper.activate(z, ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn())) != null) {
            return ret;
        }
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

