/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceToDepth
extends AbstractLayer<SpaceToDepthLayer> {
    private static final Logger log = LoggerFactory.getLogger(SpaceToDepth.class);

    public SpaceToDepth(NeuralNetConfiguration conf) {
        super(conf);
    }

    public SpaceToDepth(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    private int getBlockSize() {
        return ((SpaceToDepthLayer)this.layerConf()).getBlockSize();
    }

    private int isNHWC() {
        return ((SpaceToDepthLayer)this.layerConf()).getDataFormat().equals((Object)SpaceToDepthLayer.DataFormat.NHWC) ? 1 : 0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        int miniBatch = (int)this.input.size(0);
        int inDepth = (int)this.input.size(1);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, new int[]{1, miniBatch * inDepth * inH * inW}, 'c');
        INDArray reshapedEpsilon = this.isNHWC() == 1 ? outEpsilon.reshape('c', new int[]{miniBatch, inH, inW, inDepth}) : outEpsilon.reshape('c', new int[]{miniBatch, inDepth, inH, inW});
        DefaultGradient gradient = new DefaultGradient();
        int blockSize = this.getBlockSize();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"depth_to_space").addInputs(new INDArray[]{epsilon}).addIntegerArguments(new int[]{blockSize, this.isNHWC()}).addOutputs(new INDArray[]{reshapedEpsilon}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        reshapedEpsilon = this.backpropDropOutIfPresent(reshapedEpsilon);
        return new Pair((Object)gradient, (Object)reshapedEpsilon);
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, null);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to space to channels with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, channels, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        int miniBatch = (int)this.input.size(0);
        int depth = (int)this.input.size(1);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        int blockSize = this.getBlockSize();
        int outH = inH / blockSize;
        int outW = inW / blockSize;
        int outDepth = depth * blockSize * blockSize;
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, new int[]{1, miniBatch * outDepth * outH * outW}, 'c');
        INDArray reshapedOut = this.isNHWC() == 1 ? out.reshape('c', new int[]{miniBatch, outH, outW, outDepth}) : out.reshape('c', new int[]{miniBatch, outDepth, outH, outW});
        DynamicCustomOp op = DynamicCustomOp.builder((String)"space_to_depth").addInputs(new INDArray[]{this.input}).addIntegerArguments(new int[]{blockSize, this.isNHWC()}).addOutputs(new INDArray[]{reshapedOut}).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return reshapedOut;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.preOutput(training, false, workspaceMgr);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

