/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Or;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class MergeVertex
extends BaseGraphVertex {
    private long[][] forwardPassShapes;
    private int fwdPassRank;

    public MergeVertex(ComputationGraph graph, String name, int vertexIndex, DataType dataType) {
        this(graph, name, vertexIndex, null, null, dataType);
    }

    public MergeVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
    }

    @Override
    public String toString() {
        return "MergeVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\")";
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set");
        }
        if (this.inputs.length == 1) {
            long[] shape = this.inputs[0].shape();
            this.forwardPassShapes = new long[][]{Arrays.copyOf(shape, shape.length)};
            return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, this.inputs[0]);
        }
        INDArray[] in = new INDArray[this.inputs.length];
        for (int i = 0; i < in.length; ++i) {
            in[i] = this.inputs[i].castTo(this.dataType);
        }
        this.forwardPassShapes = new long[in.length][0];
        long nExamples = in[0].size(0);
        int nOut = 0;
        this.fwdPassRank = in[0].rank();
        for (int i = 0; i < in.length; ++i) {
            long[] currShape = in[i].shape();
            if (this.fwdPassRank != currShape.length) {
                throw new IllegalStateException("Cannot merge activations with different ranks: first activations have rank " + this.fwdPassRank + ", activations[" + i + "] have rank " + currShape.length + " (shape=" + Arrays.toString(currShape) + ")");
            }
            this.forwardPassShapes[i] = Arrays.copyOf(currShape, currShape.length);
            if (currShape[0] != nExamples) {
                throw new IllegalStateException("Cannot merge activations with different number of examples (activations[0] shape: " + Arrays.toString(in[0].shape()) + ", activations[" + i + "] shape: " + Arrays.toString(in[i].shape()));
            }
            nOut = (int)((long)nOut + currShape[1]);
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            INDArray iNDArray = Nd4j.concat((int)1, (INDArray[])in);
            return iNDArray;
        }
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set");
        }
        if (this.forwardPassShapes.length == 1) {
            return new Pair(null, (Object)new INDArray[]{workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, this.epsilon)});
        }
        INDArray[] out = new INDArray[this.forwardPassShapes.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, this.epsilon.dataType(), this.forwardPassShapes[i]);
        }
        int cumulative = 0;
        switch (this.fwdPassRank) {
            case 2: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)cumulative, (long)((long)cumulative + this.forwardPassShapes[i][1]))}));
                    cumulative = (int)((long)cumulative + this.forwardPassShapes[i][1]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)cumulative, (long)((long)cumulative + this.forwardPassShapes[i][1])), NDArrayIndex.all()}));
                    cumulative = (int)((long)cumulative + this.forwardPassShapes[i][1]);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.forwardPassShapes.length; ++i) {
                    out[i].assign(this.epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((long)cumulative, (long)((long)cumulative + this.forwardPassShapes[i][1])), NDArrayIndex.all(), NDArrayIndex.all()}));
                    cumulative = (int)((long)cumulative + this.forwardPassShapes[i][1]);
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid rank during forward pass (not 2, 3, 4)");
            }
        }
        return new Pair(null, (Object)out);
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        for (INDArray arr : maskArrays) {
            if (arr != null) continue;
            return new Pair(null, (Object)currentMaskState);
        }
        if (maskArrays.length == 1) {
            return new Pair((Object)maskArrays[0], (Object)currentMaskState);
        }
        INDArray ret = maskArrays[0].dataType() == DataType.BOOL ? maskArrays[0].dup(maskArrays[0].ordering()) : maskArrays[0].castTo(DataType.BOOL);
        Nd4j.getExecutioner().exec((Op)new Or(ret, maskArrays[1].castTo(DataType.BOOL), ret));
        for (int i = 2; i < maskArrays.length; ++i) {
            Nd4j.getExecutioner().exec((Op)new Or(maskArrays[i].castTo(DataType.BOOL), ret, ret));
        }
        return new Pair((Object)ret, (Object)currentMaskState);
    }
}

