/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.convolutional;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.ui.api.FunctionType;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.deeplearning4j.ui.views.html.convolutional.Activations;
import org.deeplearning4j.ui.weights.ConvolutionListenerPersistable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;

public class ConvolutionalListenerModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(ConvolutionalListenerModule.class);
    private static final String TYPE_ID = "ConvolutionalListener";
    private StatsStorage lastStorage;
    private String lastSessionID;
    private String lastWorkerID;
    private long lastTimeStamp;

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.singletonList(TYPE_ID);
    }

    @Override
    public List<Route> getRoutes() {
        Route r = new Route("/activations", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)Activations.apply()));
        Route r2 = new Route("/activations/data", HttpMethod.GET, FunctionType.Supplier, this::getImage);
        return Arrays.asList(r, r2);
    }

    @Override
    public synchronized void reportStorageEvents(Collection<StatsStorageEvent> events) {
        for (StatsStorageEvent sse : events) {
            if (!TYPE_ID.equals(sse.getTypeID()) || sse.getEventType() != StatsStorageListener.EventType.PostStaticInfo || sse.getTimestamp() <= this.lastTimeStamp) continue;
            this.lastStorage = sse.getStatsStorage();
            this.lastSessionID = sse.getSessionID();
            this.lastWorkerID = sse.getWorkerID();
            this.lastTimeStamp = sse.getTimestamp();
        }
    }

    @Override
    public void onAttach(StatsStorage statsStorage) {
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
    }

    @Override
    public List<I18NResource> getInternationalizationResources() {
        return Collections.emptyList();
    }

    private Result getImage() {
        if (this.lastTimeStamp > 0L && this.lastStorage != null) {
            Persistable p = this.lastStorage.getStaticInfo(this.lastSessionID, TYPE_ID, this.lastWorkerID);
            if (p instanceof ConvolutionListenerPersistable) {
                ConvolutionListenerPersistable clp = (ConvolutionListenerPersistable)p;
                BufferedImage bi = clp.getImg();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)bi, "jpg", baos);
                }
                catch (IOException e) {
                    log.warn("Error displaying image", (Throwable)e);
                }
                return Results.ok((byte[])baos.toByteArray()).as("image/jpg");
            }
            return Results.ok((byte[])new byte[0]).as("image/jpeg");
        }
        return Results.ok((byte[])new byte[0]).as("image/jpeg");
    }
}

