/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.api;

import java.util.List;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.ui.play.PlayUIServer;
import org.nd4j.linalg.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UIServer {
    private static final Logger log = LoggerFactory.getLogger(UIServer.class);
    private static UIServer uiServer;

    public static synchronized UIServer getInstance() throws RuntimeException {
        return UIServer.getInstance(false, null);
    }

    public static synchronized UIServer getInstance(boolean multiSession, Function<String, StatsStorage> statsStorageProvider) throws RuntimeException {
        if (uiServer == null || uiServer.isStopped()) {
            PlayUIServer playUIServer = new PlayUIServer(9000, multiSession);
            playUIServer.setMultiSession(multiSession);
            if (statsStorageProvider != null) {
                playUIServer.autoAttachStatsStorageBySessionId(statsStorageProvider);
            }
            playUIServer.runMain(new String[0]);
            uiServer = playUIServer;
        } else if (!uiServer.isStopped()) {
            if (multiSession && !uiServer.isMultiSession()) {
                throw new RuntimeException("Cannot return multi-session instance. UIServer has already started in single-session mode at " + uiServer.getAddress() + " You may stop the UI server instance, and start a new one.");
            }
            if (!multiSession && uiServer.isMultiSession()) {
                throw new RuntimeException("Cannot return single-session instance. UIServer has already started in multi-session mode at " + uiServer.getAddress() + " You may stop the UI server instance, and start a new one.");
            }
        }
        return uiServer;
    }

    public static void stopInstance() {
        if (uiServer != null) {
            uiServer.stop();
        }
    }

    public abstract boolean isStopped();

    public abstract boolean isMultiSession();

    public abstract String getAddress();

    public abstract int getPort();

    public abstract void attach(StatsStorage var1);

    public abstract void detach(StatsStorage var1);

    public abstract boolean isAttached(StatsStorage var1);

    public abstract List<StatsStorage> getStatsStorageInstances();

    public abstract void enableRemoteListener();

    public abstract void enableRemoteListener(StatsStorageRouter var1, boolean var2);

    public abstract void disableRemoteListener();

    public abstract boolean isRemoteListenerEnabled();

    public abstract void stop();
}

