/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.api.I18N;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultI18N
implements I18N {
    private static final Logger log = LoggerFactory.getLogger(DefaultI18N.class);
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String FALLBACK_LANGUAGE = "en";
    private static DefaultI18N instance;
    private static Map<String, I18N> sessionInstances;
    private static Throwable languageLoadingException;
    private String currentLanguage = "en";
    private Map<String, Map<String, String>> messagesByLanguage = new HashMap<String, Map<String, String>>();

    public static synchronized I18N getInstance() {
        if (instance == null) {
            instance = new DefaultI18N();
        }
        return instance;
    }

    public static synchronized I18N getInstance(String sessionId) {
        if (!sessionInstances.containsKey(sessionId)) {
            sessionInstances.put(sessionId, new DefaultI18N());
        }
        return sessionInstances.get(sessionId);
    }

    public static synchronized I18N removeInstance(String sessionId) {
        return sessionInstances.remove(sessionId);
    }

    private DefaultI18N() {
        this.loadLanguages();
    }

    private synchronized void loadLanguages() {
        ServiceLoader<UIModule> sl = ServiceLoader.load(UIModule.class);
        for (UIModule m : sl) {
            List<I18NResource> resources = m.getInternationalizationResources();
            for (I18NResource r : resources) {
                try {
                    String path = r.getResource();
                    int idxLast = path.lastIndexOf(46);
                    if (idxLast < 0) {
                        log.warn("Skipping language resource file: cannot infer language: {}", (Object)path);
                        continue;
                    }
                    String langCode = path.substring(idxLast + 1).toLowerCase();
                    Map map = this.messagesByLanguage.computeIfAbsent(langCode, k -> new HashMap());
                    this.parseFile(r, map);
                }
                catch (Throwable t) {
                    log.warn("Error parsing UI I18N content file; skipping: {}", (Object)r.getResource(), (Object)t);
                    languageLoadingException = t;
                }
            }
        }
    }

    public Throwable getLanguageLoadingException() {
        return languageLoadingException;
    }

    public boolean noI18NData() {
        if (this.messagesByLanguage.isEmpty()) {
            return true;
        }
        boolean noData = true;
        for (Map.Entry<String, Map<String, String>> e : this.messagesByLanguage.entrySet()) {
            if (e.getValue() == null || e.getValue().isEmpty()) continue;
            noData = false;
            break;
        }
        return noData;
    }

    private void parseFile(I18NResource r, Map<String, String> results) {
        List lines;
        try {
            InputStream is = r.getInputStream();
            Object object = null;
            try {
                lines = IOUtils.readLines((InputStream)is, (Charset)Charset.forName("UTF-8"));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.debug("Error parsing UI I18N content file; skipping: {}", (Object)r.getResource(), (Object)e.getMessage());
            return;
        }
        int count = 0;
        for (String line : lines) {
            if (!line.matches(".+=.*")) {
                log.debug("Invalid line in I18N file: {}, \"{}\"", (Object)r.getResource(), (Object)line);
                continue;
            }
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(Math.min(idx + 1, line.length()));
            results.put(key, value);
            ++count;
        }
        log.trace("Loaded {} messages from file {}", (Object)count, (Object)r.getResource());
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(this.currentLanguage, key);
    }

    @Override
    public String getMessage(String langCode, String key) {
        String msg;
        Map<String, String> messagesForLanguage = this.messagesByLanguage.get(langCode);
        if (messagesForLanguage != null) {
            msg = messagesForLanguage.get(key);
            if (msg == null && !"en".equals(langCode)) {
                return this.getMessage("en", key);
            }
        } else {
            msg = this.getMessage("en", key);
        }
        return msg;
    }

    @Override
    public String getDefaultLanguage() {
        return this.currentLanguage;
    }

    @Override
    public void setDefaultLanguage(String langCode) {
        this.currentLanguage = langCode;
        log.debug("UI: Set language to {}", (Object)langCode);
    }

    static {
        sessionInstances = Collections.synchronizedMap(new HashMap());
        languageLoadingException = null;
    }
}

