/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.play;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.ui.SameDiffModule;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.i18n.DefaultI18N;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.module.convolutional.ConvolutionalListenerModule;
import org.deeplearning4j.ui.module.defaultModule.DefaultModule;
import org.deeplearning4j.ui.module.remote.RemoteReceiverModule;
import org.deeplearning4j.ui.module.train.TrainModule;
import org.deeplearning4j.ui.module.tsne.TsneModule;
import org.deeplearning4j.ui.play.misc.FunctionUtil;
import org.deeplearning4j.ui.play.staticroutes.Assets;
import org.deeplearning4j.ui.play.staticroutes.I18NRoute;
import org.deeplearning4j.ui.play.staticroutes.MultiSessionI18NRoute;
import org.deeplearning4j.ui.storage.FileStatsStorage;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;
import org.deeplearning4j.ui.storage.impl.QueueStatsStorageListener;
import org.deeplearning4j.util.DL4JFileUtils;
import org.nd4j.linalg.function.Function;
import org.nd4j.linalg.function.Supplier;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Mode;
import play.api.routing.Router;
import play.routing.RoutingDsl;
import play.server.Server;

public class PlayUIServer
extends UIServer {
    private static final Logger log = LoggerFactory.getLogger(PlayUIServer.class);
    @Deprecated
    public static final String UI_SERVER_PORT_PROPERTY = "org.deeplearning4j.ui.port";
    public static final int DEFAULT_UI_PORT = 9000;
    public static final String ASSETS_ROOT_DIRECTORY = "deeplearning4jUiAssets/";
    private Server server;
    private boolean stopped;
    private final BlockingQueue<StatsStorageEvent> eventQueue = new LinkedBlockingQueue<StatsStorageEvent>();
    private List<Pair<StatsStorage, StatsStorageListener>> listeners = new CopyOnWriteArrayList<Pair<StatsStorage, StatsStorageListener>>();
    private List<StatsStorage> statsStorageInstances = new CopyOnWriteArrayList<StatsStorage>();
    private List<UIModule> uiModules = new CopyOnWriteArrayList<UIModule>();
    private RemoteReceiverModule remoteReceiverModule;
    private Map<String, List<UIModule>> typeIDModuleMap = new ConcurrentHashMap<String, List<UIModule>>();
    private long uiProcessingDelay = 500L;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Thread uiEventRoutingThread;
    @Parameter(names={"-r", "--enableRemote"}, description="Whether to enable remote or not", arity=1)
    private boolean enableRemote;
    @Parameter(names={"-p", "--uiPort"}, description="Custom HTTP port for UI", arity=1)
    private int port = 9000;
    @Parameter(names={"-f", "--customStatsFile"}, description="Path to create custom stats file (remote only)", arity=1)
    private String customStatsFile;
    @Parameter(names={"-m", "--multiSession"}, description="Whether to enable multiple separate browser sessions or not", arity=1)
    private boolean multiSession;
    private StatsStorageLoader statsStorageLoader;

    public PlayUIServer() {
        this(9000);
    }

    public PlayUIServer(int port) {
        this(port, false);
    }

    public PlayUIServer(int port, boolean multiSession) {
        this.port = port;
        this.multiSession = multiSession;
    }

    public void autoAttachStatsStorageBySessionId(Function<String, StatsStorage> statsStorageProvider) {
        if (statsStorageProvider != null) {
            this.statsStorageLoader = new StatsStorageLoader(statsStorageProvider);
        }
    }

    public void runMain(String[] args) {
        String crypto;
        JCommander jcmdr = new JCommander((Object)this);
        try {
            jcmdr.parse(args);
        }
        catch (ParameterException e) {
            jcmdr.usage();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        if (((DefaultI18N)I18NProvider.getInstance()).noI18NData()) {
            Throwable t = ((DefaultI18N)I18NProvider.getInstance()).getLanguageLoadingException();
            if (t != null) {
                throw new RuntimeException("Exception encountered during loading UI Language (Internationalization) data", t);
            }
            log.error("Error loading UI Language (Internationalization) data: no language resource data files werefound on the classpath. This usually occurs when running DL4J's UI from an uber-jar, which was built incorrectly (without language resource files). See https://deeplearning4j.org/docs/latest/deeplearning4j-nn-visualization#issuesfor more details");
            System.exit(1);
        }
        RoutingDsl routingDsl = new RoutingDsl();
        if (this.multiSession) {
            routingDsl.GET("/setlang/:sessionId/:to").routeTo(FunctionUtil.biFunction(new MultiSessionI18NRoute()));
        } else {
            routingDsl.GET("/setlang/:to").routeTo(FunctionUtil.function(new I18NRoute()));
        }
        routingDsl.GET("/assets/*file").routeTo(FunctionUtil.function(new Assets(ASSETS_ROOT_DIRECTORY)));
        this.uiModules.add(new DefaultModule(this.multiSession));
        this.uiModules.add(new TrainModule(this.multiSession, this.statsStorageLoader, (Supplier<String>)((Supplier)this::getAddress)));
        this.uiModules.add(new ConvolutionalListenerModule());
        this.uiModules.add(new TsneModule());
        this.uiModules.add(new SameDiffModule());
        this.remoteReceiverModule = new RemoteReceiverModule();
        this.uiModules.add(this.remoteReceiverModule);
        this.modulesViaServiceLoader(this.uiModules);
        for (UIModule m : this.uiModules) {
            List<Route> routes = m.getRoutes();
            block16: for (Route r : routes) {
                RoutingDsl.PathPatternMatcher ppm = routingDsl.match(r.getHttpMethod().name(), r.getRoute());
                switch (r.getFunctionType()) {
                    case Supplier: {
                        ppm.routeTo(FunctionUtil.function0(r.getSupplier()));
                        continue block16;
                    }
                    case Function: {
                        ppm.routeTo(FunctionUtil.function(r.getFunction()));
                        continue block16;
                    }
                    case BiFunction: {
                        ppm.routeTo(FunctionUtil.biFunction(r.getFunction2()));
                        continue block16;
                    }
                }
                throw new RuntimeException("Not yet implemented");
            }
            List<String> typeIDs = m.getCallbackTypeIDs();
            for (String typeID : typeIDs) {
                List<UIModule> list = this.typeIDModuleMap.get(typeID);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.typeIDModuleMap.put(typeID, list);
                }
                list.add(m);
            }
        }
        String portProperty = System.getProperty(UI_SERVER_PORT_PROPERTY);
        if (portProperty != null) {
            try {
                this.port = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse UI port property \"{}\" with value \"{}\"", new Object[]{UI_SERVER_PORT_PROPERTY, portProperty, e});
            }
        }
        if ((crypto = System.getProperty("play.crypto.secret")) == null || "changeme".equals(crypto) || "".equals(crypto)) {
            byte[] newCrypto = new byte[1024];
            new Random().nextBytes(newCrypto);
            String base64 = Base64.getEncoder().encodeToString(newCrypto);
            System.setProperty("play.crypto.secret", base64);
        }
        Router router = routingDsl.build();
        try {
            this.server = Server.forRouter((Router)router, (Mode)Mode.PROD, (int)this.port);
        }
        catch (Throwable e) {
            if (e.getMessage().contains("'play.crypto.provider")) {
                log.error("Error starting UI server due to missing play.crypto.provider config: This usually occurs due to missing application.conf file. DL4J's UI (based on the Play framework) requires this file in order to run. File can be missing due to incorrect creation of uber-jars that do not include resource files. See https://deeplearning4j.org/docs/latest/deeplearning4j-nn-visualization#issues for more information", e);
            } else {
                log.error("Unknown error when starting UI server", e);
            }
            throw e;
        }
        log.info("DL4J UI Server started at {}", (Object)this.getAddress());
        this.uiEventRoutingThread = new Thread(new StatsEventRouterRunnable());
        this.uiEventRoutingThread.setDaemon(true);
        this.uiEventRoutingThread.start();
        if (this.enableRemote && this.customStatsFile != null) {
            this.enableRemoteListener((StatsStorageRouter)new FileStatsStorage(new File(this.customStatsFile)), true);
        } else if (this.enableRemote) {
            try {
                File tempStatsFile = DL4JFileUtils.createTempFile((String)"dl4j", (String)"UIstats");
                tempStatsFile.delete();
                tempStatsFile.deleteOnExit();
                this.enableRemoteListener((StatsStorageRouter)new FileStatsStorage(tempStatsFile), true);
            }
            catch (Exception e) {
                log.error("Failed to create temporary file for stats storage", (Throwable)e);
                System.exit(1);
            }
        }
        this.setStopped(false);
    }

    @Override
    public String getAddress() {
        int last;
        String addr = this.server.mainAddress().toString();
        if (addr.startsWith("/0:0:0:0:0:0:0:0") && (last = addr.lastIndexOf(58)) > 0) {
            addr = "http://localhost:" + addr.substring(last + 1);
        }
        return addr;
    }

    private void modulesViaServiceLoader(List<UIModule> uiModules) {
        ServiceLoader<UIModule> sl = ServiceLoader.load(UIModule.class);
        Iterator<UIModule> iter = sl.iterator();
        if (!iter.hasNext()) {
            return;
        }
        while (iter.hasNext()) {
            UIModule m = iter.next();
            Class<?> c = m.getClass();
            boolean foundExisting = false;
            for (UIModule mExisting : uiModules) {
                if (mExisting.getClass() != c) continue;
                foundExisting = true;
                break;
            }
            if (foundExisting) continue;
            log.debug("Loaded UI module via service loader: {}", m.getClass());
            uiModules.add(m);
        }
    }

    public static void main(String[] args) {
        new PlayUIServer().runMain(args);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized void attach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        QueueStatsStorageListener listener = new QueueStatsStorageListener(this.eventQueue);
        this.listeners.add((Pair<StatsStorage, StatsStorageListener>)new Pair((Object)statsStorage, (Object)listener));
        statsStorage.registerStatsStorageListener((StatsStorageListener)listener);
        this.statsStorageInstances.add(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onAttach(statsStorage);
        }
        log.info("StatsStorage instance attached to UI: {}", (Object)statsStorage);
    }

    @Override
    public synchronized void detach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (!this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        boolean found = false;
        for (Pair<StatsStorage, StatsStorageListener> p : this.listeners) {
            if (p.getFirst() != statsStorage) continue;
            statsStorage.deregisterStatsStorageListener((StatsStorageListener)p.getSecond());
            this.listeners.remove(p);
            found = true;
        }
        this.statsStorageInstances.remove(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onDetach(statsStorage);
        }
        for (String sessionId : statsStorage.listSessionIDs()) {
            I18NProvider.removeInstance(sessionId);
        }
        if (found) {
            log.info("StatsStorage instance detached from UI: {}", (Object)statsStorage);
        }
    }

    @Override
    public boolean isAttached(StatsStorage statsStorage) {
        return this.statsStorageInstances.contains(statsStorage);
    }

    @Override
    public List<StatsStorage> getStatsStorageInstances() {
        return new ArrayList<StatsStorage>(this.statsStorageInstances);
    }

    @Override
    public void enableRemoteListener() {
        if (this.remoteReceiverModule == null) {
            this.remoteReceiverModule = new RemoteReceiverModule();
        }
        if (this.remoteReceiverModule.isEnabled()) {
            return;
        }
        this.enableRemoteListener((StatsStorageRouter)new InMemoryStatsStorage(), true);
    }

    @Override
    public void enableRemoteListener(StatsStorageRouter statsStorage, boolean attach) {
        this.remoteReceiverModule.setEnabled(true);
        this.remoteReceiverModule.setStatsStorage(statsStorage);
        if (attach && statsStorage instanceof StatsStorage) {
            this.attach((StatsStorage)statsStorage);
        }
    }

    @Override
    public void disableRemoteListener() {
        this.remoteReceiverModule.setEnabled(false);
    }

    @Override
    public boolean isRemoteListenerEnabled() {
        return this.remoteReceiverModule.isEnabled();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.setStopped(true);
        }
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public BlockingQueue<StatsStorageEvent> getEventQueue() {
        return this.eventQueue;
    }

    public List<Pair<StatsStorage, StatsStorageListener>> getListeners() {
        return this.listeners;
    }

    public List<UIModule> getUiModules() {
        return this.uiModules;
    }

    public RemoteReceiverModule getRemoteReceiverModule() {
        return this.remoteReceiverModule;
    }

    public Map<String, List<UIModule>> getTypeIDModuleMap() {
        return this.typeIDModuleMap;
    }

    public long getUiProcessingDelay() {
        return this.uiProcessingDelay;
    }

    public AtomicBoolean getShutdown() {
        return this.shutdown;
    }

    public Thread getUiEventRoutingThread() {
        return this.uiEventRoutingThread;
    }

    public boolean isEnableRemote() {
        return this.enableRemote;
    }

    public String getCustomStatsFile() {
        return this.customStatsFile;
    }

    @Override
    public boolean isMultiSession() {
        return this.multiSession;
    }

    public StatsStorageLoader getStatsStorageLoader() {
        return this.statsStorageLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void setListeners(List<Pair<StatsStorage, StatsStorageListener>> listeners) {
        this.listeners = listeners;
    }

    public void setStatsStorageInstances(List<StatsStorage> statsStorageInstances) {
        this.statsStorageInstances = statsStorageInstances;
    }

    public void setUiModules(List<UIModule> uiModules) {
        this.uiModules = uiModules;
    }

    public void setRemoteReceiverModule(RemoteReceiverModule remoteReceiverModule) {
        this.remoteReceiverModule = remoteReceiverModule;
    }

    public void setTypeIDModuleMap(Map<String, List<UIModule>> typeIDModuleMap) {
        this.typeIDModuleMap = typeIDModuleMap;
    }

    public void setUiProcessingDelay(long uiProcessingDelay) {
        this.uiProcessingDelay = uiProcessingDelay;
    }

    public void setUiEventRoutingThread(Thread uiEventRoutingThread) {
        this.uiEventRoutingThread = uiEventRoutingThread;
    }

    public void setEnableRemote(boolean enableRemote) {
        this.enableRemote = enableRemote;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCustomStatsFile(String customStatsFile) {
        this.customStatsFile = customStatsFile;
    }

    public void setMultiSession(boolean multiSession) {
        this.multiSession = multiSession;
    }

    public void setStatsStorageLoader(StatsStorageLoader statsStorageLoader) {
        this.statsStorageLoader = statsStorageLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayUIServer)) {
            return false;
        }
        PlayUIServer other = (PlayUIServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        if (this.isStopped() != other.isStopped()) {
            return false;
        }
        BlockingQueue<StatsStorageEvent> this$eventQueue = this.getEventQueue();
        BlockingQueue<StatsStorageEvent> other$eventQueue = other.getEventQueue();
        if (this$eventQueue == null ? other$eventQueue != null : !this$eventQueue.equals(other$eventQueue)) {
            return false;
        }
        List<Pair<StatsStorage, StatsStorageListener>> this$listeners = this.getListeners();
        List<Pair<StatsStorage, StatsStorageListener>> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<StatsStorage> this$statsStorageInstances = this.getStatsStorageInstances();
        List<StatsStorage> other$statsStorageInstances = other.getStatsStorageInstances();
        if (this$statsStorageInstances == null ? other$statsStorageInstances != null : !((Object)this$statsStorageInstances).equals(other$statsStorageInstances)) {
            return false;
        }
        List<UIModule> this$uiModules = this.getUiModules();
        List<UIModule> other$uiModules = other.getUiModules();
        if (this$uiModules == null ? other$uiModules != null : !((Object)this$uiModules).equals(other$uiModules)) {
            return false;
        }
        RemoteReceiverModule this$remoteReceiverModule = this.getRemoteReceiverModule();
        RemoteReceiverModule other$remoteReceiverModule = other.getRemoteReceiverModule();
        if (this$remoteReceiverModule == null ? other$remoteReceiverModule != null : !this$remoteReceiverModule.equals(other$remoteReceiverModule)) {
            return false;
        }
        Map<String, List<UIModule>> this$typeIDModuleMap = this.getTypeIDModuleMap();
        Map<String, List<UIModule>> other$typeIDModuleMap = other.getTypeIDModuleMap();
        if (this$typeIDModuleMap == null ? other$typeIDModuleMap != null : !((Object)this$typeIDModuleMap).equals(other$typeIDModuleMap)) {
            return false;
        }
        if (this.getUiProcessingDelay() != other.getUiProcessingDelay()) {
            return false;
        }
        AtomicBoolean this$shutdown = this.getShutdown();
        AtomicBoolean other$shutdown = other.getShutdown();
        if (this$shutdown == null ? other$shutdown != null : !this$shutdown.equals(other$shutdown)) {
            return false;
        }
        Thread this$uiEventRoutingThread = this.getUiEventRoutingThread();
        Thread other$uiEventRoutingThread = other.getUiEventRoutingThread();
        if (this$uiEventRoutingThread == null ? other$uiEventRoutingThread != null : !this$uiEventRoutingThread.equals(other$uiEventRoutingThread)) {
            return false;
        }
        if (this.isEnableRemote() != other.isEnableRemote()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$customStatsFile = this.getCustomStatsFile();
        String other$customStatsFile = other.getCustomStatsFile();
        if (this$customStatsFile == null ? other$customStatsFile != null : !this$customStatsFile.equals(other$customStatsFile)) {
            return false;
        }
        if (this.isMultiSession() != other.isMultiSession()) {
            return false;
        }
        StatsStorageLoader this$statsStorageLoader = this.getStatsStorageLoader();
        StatsStorageLoader other$statsStorageLoader = other.getStatsStorageLoader();
        return !(this$statsStorageLoader == null ? other$statsStorageLoader != null : !this$statsStorageLoader.equals(other$statsStorageLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayUIServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        result = result * 59 + (this.isStopped() ? 79 : 97);
        BlockingQueue<StatsStorageEvent> $eventQueue = this.getEventQueue();
        result = result * 59 + ($eventQueue == null ? 43 : $eventQueue.hashCode());
        List<Pair<StatsStorage, StatsStorageListener>> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<StatsStorage> $statsStorageInstances = this.getStatsStorageInstances();
        result = result * 59 + ($statsStorageInstances == null ? 43 : ((Object)$statsStorageInstances).hashCode());
        List<UIModule> $uiModules = this.getUiModules();
        result = result * 59 + ($uiModules == null ? 43 : ((Object)$uiModules).hashCode());
        RemoteReceiverModule $remoteReceiverModule = this.getRemoteReceiverModule();
        result = result * 59 + ($remoteReceiverModule == null ? 43 : $remoteReceiverModule.hashCode());
        Map<String, List<UIModule>> $typeIDModuleMap = this.getTypeIDModuleMap();
        result = result * 59 + ($typeIDModuleMap == null ? 43 : ((Object)$typeIDModuleMap).hashCode());
        long $uiProcessingDelay = this.getUiProcessingDelay();
        result = result * 59 + (int)($uiProcessingDelay >>> 32 ^ $uiProcessingDelay);
        AtomicBoolean $shutdown = this.getShutdown();
        result = result * 59 + ($shutdown == null ? 43 : $shutdown.hashCode());
        Thread $uiEventRoutingThread = this.getUiEventRoutingThread();
        result = result * 59 + ($uiEventRoutingThread == null ? 43 : $uiEventRoutingThread.hashCode());
        result = result * 59 + (this.isEnableRemote() ? 79 : 97);
        result = result * 59 + this.getPort();
        String $customStatsFile = this.getCustomStatsFile();
        result = result * 59 + ($customStatsFile == null ? 43 : $customStatsFile.hashCode());
        result = result * 59 + (this.isMultiSession() ? 79 : 97);
        StatsStorageLoader $statsStorageLoader = this.getStatsStorageLoader();
        result = result * 59 + ($statsStorageLoader == null ? 43 : $statsStorageLoader.hashCode());
        return result;
    }

    public String toString() {
        return "PlayUIServer(server=" + this.getServer() + ", stopped=" + this.isStopped() + ", eventQueue=" + this.getEventQueue() + ", listeners=" + this.getListeners() + ", statsStorageInstances=" + this.getStatsStorageInstances() + ", uiModules=" + this.getUiModules() + ", remoteReceiverModule=" + this.getRemoteReceiverModule() + ", typeIDModuleMap=" + this.getTypeIDModuleMap() + ", uiProcessingDelay=" + this.getUiProcessingDelay() + ", shutdown=" + this.getShutdown() + ", uiEventRoutingThread=" + this.getUiEventRoutingThread() + ", enableRemote=" + this.isEnableRemote() + ", port=" + this.getPort() + ", customStatsFile=" + this.getCustomStatsFile() + ", multiSession=" + this.isMultiSession() + ", statsStorageLoader=" + this.getStatsStorageLoader() + ")";
    }

    private class StatsStorageLoader
    implements Function<String, Boolean> {
        Function<String, StatsStorage> statsStorageProvider;

        StatsStorageLoader(Function<String, StatsStorage> statsStorageProvider) {
            this.statsStorageProvider = statsStorageProvider;
        }

        public Boolean apply(String sessionId) {
            log.info("Loading StatsStorage via StatsStorageProvider for session ID (" + sessionId + ").");
            StatsStorage statsStorage = (StatsStorage)this.statsStorageProvider.apply((Object)sessionId);
            if (statsStorage != null) {
                if (statsStorage.sessionExists(sessionId)) {
                    PlayUIServer.this.attach(statsStorage);
                    return true;
                }
                log.info("Failed to load StatsStorage via StatsStorageProvider for session ID. Session ID (" + sessionId + ") does not exist in StatsStorage.");
                return false;
            }
            log.info("Failed to load StatsStorage via StatsStorageProvider for session ID (" + sessionId + "). StatsStorageProvider returned null.");
            return false;
        }
    }

    private class StatsEventRouterRunnable
    implements Runnable {
        private StatsEventRouterRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runHelper();
            }
            catch (Exception e) {
                log.error("Unexpected exception from Event routing runnable", (Throwable)e);
            }
        }

        private void runHelper() throws Exception {
            log.debug("PlayUIServer.StatsEventRouterRunnable started");
            while (!PlayUIServer.this.shutdown.get()) {
                ArrayList<StatsStorageEvent> events = new ArrayList<StatsStorageEvent>();
                StatsStorageEvent sse = (StatsStorageEvent)PlayUIServer.this.eventQueue.take();
                events.add(sse);
                PlayUIServer.this.eventQueue.drainTo(events);
                for (UIModule m : PlayUIServer.this.uiModules) {
                    List<String> callbackTypes = m.getCallbackTypeIDs();
                    ArrayList<StatsStorageEvent> out = new ArrayList<StatsStorageEvent>();
                    for (StatsStorageEvent e : events) {
                        if (!callbackTypes.contains(e.getTypeID()) || !PlayUIServer.this.statsStorageInstances.contains(e.getStatsStorage())) continue;
                        out.add(e);
                    }
                    m.reportStorageEvents(out);
                }
                events.clear();
                try {
                    Thread.sleep(PlayUIServer.this.uiProcessingDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (PlayUIServer.this.shutdown.get()) continue;
                    throw new RuntimeException("Unexpected interrupted exception", e);
                }
            }
        }
    }
}

