/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.play.staticroutes;

import java.io.InputStream;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.nd4j.linalg.io.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.MimeTypes;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import scala.Option;

public class Assets
implements Function<String, Result> {
    private static final Logger log = LoggerFactory.getLogger(Assets.class);
    private final String assetsRootDirectory;

    @Override
    public Result apply(String s) {
        InputStream inputStream;
        String fullPath = s.startsWith("webjars/") ? "META-INF/resources/" + s : this.assetsRootDirectory + s;
        try {
            inputStream = new ClassPathResource(fullPath).getInputStream();
        }
        catch (Throwable t) {
            log.warn("Could not find requested UI asset: {}", (Object)s, (Object)t);
            return Results.ok();
        }
        String fileName = FilenameUtils.getName((String)fullPath);
        Http.Context.Implicit.response().setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        Option contentType = MimeTypes.forFileName((String)fileName);
        String ct = contentType.isDefined() ? (String)contentType.get() : "application/octet-stream";
        return Results.ok((InputStream)inputStream).as(ct);
    }

    public Assets(String assetsRootDirectory) {
        this.assetsRootDirectory = assetsRootDirectory;
    }
}

