/*-
 *
 *  * Copyright 2016 Skymind,Inc.
 *  *
 *  *    Licensed under the Apache License, Version 2.0 (the "License");
 *  *    you may not use this file except in compliance with the License.
 *  *    You may obtain a copy of the License at
 *  *
 *  *        http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  *    Unless required by applicable law or agreed to in writing, software
 *  *    distributed under the License is distributed on an "AS IS" BASIS,
 *  *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *    See the License for the specific language governing permissions and
 *  *    limitations under the License.
 *
 */
package org.deeplearning4j.ui.components.component;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.api.Style;
import org.nd4j.shade.jackson.annotation.JsonInclude;

import java.util.Collection;

/**
 * Div component (as in, HTML div)
 *
 * @author Alex Black
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ComponentDiv extends Component {
    public static final String COMPONENT_TYPE = "ComponentDiv";

    private Component[] components;

    public ComponentDiv() {
        super(COMPONENT_TYPE, null);
    }


    public ComponentDiv(Style style, Component... components) {
        super(COMPONENT_TYPE, style);
        this.components = components;
    }

    public ComponentDiv(Style style, Collection<Component> componentCollection) {
        this(style, (componentCollection == null ? null
                        : componentCollection.toArray(new Component[componentCollection.size()])));
    }
}
