/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.stats.api.Histogram;
import org.deeplearning4j.ui.stats.api.StatsReport;
import org.deeplearning4j.ui.stats.impl.SbeUtil;
import org.deeplearning4j.ui.stats.sbe.MemoryType;
import org.deeplearning4j.ui.stats.sbe.MessageHeaderDecoder;
import org.deeplearning4j.ui.stats.sbe.MessageHeaderEncoder;
import org.deeplearning4j.ui.stats.sbe.StatsType;
import org.deeplearning4j.ui.stats.sbe.SummaryType;
import org.deeplearning4j.ui.stats.sbe.UpdateDecoder;
import org.deeplearning4j.ui.stats.sbe.UpdateEncoder;
import org.deeplearning4j.ui.stats.sbe.UpdateFieldsPresentDecoder;
import org.deeplearning4j.ui.storage.AgronaPersistable;
import org.nd4j.linalg.primitives.Pair;

public class SbeStatsReport
implements StatsReport,
AgronaPersistable {
    private String sessionID;
    private String typeID;
    private String workerID;
    private long timeStamp;
    private int iterationCount;
    private int statsCollectionDurationMs;
    private double score;
    private long jvmCurrentBytes;
    private long jvmMaxBytes;
    private long offHeapCurrentBytes;
    private long offHeapMaxBytes;
    private long[] deviceCurrentBytes;
    private long[] deviceMaxBytes;
    private long totalRuntimeMs;
    private long totalExamples;
    private long totalMinibatches;
    private double examplesPerSecond;
    private double minibatchesPerSecond;
    private List<GCStats> gcStats;
    private Map<String, Double> learningRatesByParam;
    private Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> histograms;
    private Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> meanValues;
    private Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> stdevValues;
    private Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> meanMagnitudeValues;
    private String metaDataClassName;
    private List<byte[]> dataSetMetaData;
    private boolean scorePresent;
    private boolean memoryUsePresent;
    private boolean performanceStatsPresent;

    @Override
    public void reportIDs(String sessionID, String typeID, String workerID, long timeStamp) {
        this.sessionID = sessionID;
        this.typeID = typeID;
        this.workerID = workerID;
        this.timeStamp = timeStamp;
    }

    @Override
    public void reportIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    @Override
    public void reportStatsCollectionDurationMS(int statsCollectionDurationMS) {
        this.statsCollectionDurationMs = statsCollectionDurationMS;
    }

    @Override
    public void reportScore(double currentScore) {
        this.score = currentScore;
        this.scorePresent = true;
    }

    @Override
    public void reportLearningRates(Map<String, Double> learningRatesByParam) {
        this.learningRatesByParam = learningRatesByParam;
    }

    @Override
    public Map<String, Double> getLearningRates() {
        return this.learningRatesByParam;
    }

    @Override
    public void reportMemoryUse(long jvmCurrentBytes, long jvmMaxBytes, long offHeapCurrentBytes, long offHeapMaxBytes, long[] deviceCurrentBytes, long[] deviceMaxBytes) {
        this.jvmCurrentBytes = jvmCurrentBytes;
        this.jvmMaxBytes = jvmMaxBytes;
        this.offHeapCurrentBytes = offHeapCurrentBytes;
        this.offHeapMaxBytes = offHeapMaxBytes;
        this.deviceCurrentBytes = deviceCurrentBytes;
        this.deviceMaxBytes = deviceMaxBytes;
        this.memoryUsePresent = true;
    }

    @Override
    public void reportPerformance(long totalRuntimeMs, long totalExamples, long totalMinibatches, double examplesPerSecond, double minibatchesPerSecond) {
        this.totalRuntimeMs = totalRuntimeMs;
        this.totalExamples = totalExamples;
        this.totalMinibatches = totalMinibatches;
        this.examplesPerSecond = examplesPerSecond;
        this.minibatchesPerSecond = minibatchesPerSecond;
        this.performanceStatsPresent = true;
    }

    @Override
    public void reportGarbageCollection(String gcName, int deltaGCCount, int deltaGCTime) {
        if (this.gcStats == null) {
            this.gcStats = new ArrayList<GCStats>();
        }
        this.gcStats.add(new GCStats(gcName, deltaGCCount, deltaGCTime));
    }

    @Override
    public List<Pair<String, int[]>> getGarbageCollectionStats() {
        if (this.gcStats == null) {
            return null;
        }
        ArrayList<Pair<String, int[]>> temp = new ArrayList<Pair<String, int[]>>();
        for (GCStats g : this.gcStats) {
            temp.add((Pair<String, int[]>)new Pair((Object)g.gcName, (Object)new int[]{g.getDeltaGCCount(), g.getDeltaGCTime()}));
        }
        return temp;
    }

    @Override
    public void reportHistograms(org.deeplearning4j.ui.stats.api.StatsType statsType, Map<String, Histogram> histogram) {
        if (this.histograms == null) {
            this.histograms = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>>();
        }
        this.histograms.put(statsType, histogram);
    }

    @Override
    public Map<String, Histogram> getHistograms(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        if (this.histograms == null) {
            return null;
        }
        return this.histograms.get((Object)statsType);
    }

    @Override
    public void reportMean(org.deeplearning4j.ui.stats.api.StatsType statsType, Map<String, Double> mean) {
        if (this.meanValues == null) {
            this.meanValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
        }
        this.meanValues.put(statsType, mean);
    }

    @Override
    public Map<String, Double> getMean(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        if (this.meanValues == null) {
            return null;
        }
        return this.meanValues.get((Object)statsType);
    }

    @Override
    public void reportStdev(org.deeplearning4j.ui.stats.api.StatsType statsType, Map<String, Double> stdev) {
        if (this.stdevValues == null) {
            this.stdevValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
        }
        this.stdevValues.put(statsType, stdev);
    }

    @Override
    public Map<String, Double> getStdev(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        if (this.stdevValues == null) {
            return null;
        }
        return this.stdevValues.get((Object)statsType);
    }

    @Override
    public void reportMeanMagnitudes(org.deeplearning4j.ui.stats.api.StatsType statsType, Map<String, Double> meanMagnitudes) {
        if (this.meanMagnitudeValues == null) {
            this.meanMagnitudeValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
        }
        this.meanMagnitudeValues.put(statsType, meanMagnitudes);
    }

    @Override
    public void reportDataSetMetaData(List<Serializable> dataSetMetaData, Class<?> metaDataClass) {
        this.reportDataSetMetaData(dataSetMetaData, metaDataClass == null ? null : metaDataClass.getName());
    }

    @Override
    public void reportDataSetMetaData(List<Serializable> dataSetMetaData, String metaDataClass) {
        if (dataSetMetaData != null) {
            this.dataSetMetaData = new ArrayList<byte[]>();
            for (Serializable s : dataSetMetaData) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(s);
                    oos.flush();
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException from ByteArrayOutputStream", e);
                }
                byte[] b = baos.toByteArray();
                this.dataSetMetaData.add(b);
            }
        } else {
            this.dataSetMetaData = null;
        }
        this.metaDataClassName = metaDataClass;
    }

    @Override
    public Map<String, Double> getMeanMagnitudes(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        if (this.meanMagnitudeValues == null) {
            return null;
        }
        return this.meanMagnitudeValues.get((Object)statsType);
    }

    @Override
    public List<Serializable> getDataSetMetaData() {
        if (this.dataSetMetaData == null || this.dataSetMetaData.isEmpty()) {
            return null;
        }
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        for (byte[] b : this.dataSetMetaData) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(b));
                Throwable throwable = null;
                try {
                    l.add((Serializable)ois.readObject());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ois == null) continue;
                    if (throwable != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ois.close();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return l;
    }

    @Override
    public String getDataSetMetaDataClassName() {
        return this.metaDataClassName;
    }

    @Override
    public boolean hasScore() {
        return this.scorePresent;
    }

    @Override
    public boolean hasLearningRates() {
        return this.learningRatesByParam != null;
    }

    @Override
    public boolean hasMemoryUse() {
        return this.memoryUsePresent;
    }

    @Override
    public boolean hasPerformance() {
        return this.performanceStatsPresent;
    }

    @Override
    public boolean hasGarbageCollection() {
        return this.gcStats != null && !this.gcStats.isEmpty();
    }

    @Override
    public boolean hasHistograms(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        if (this.histograms == null) {
            return false;
        }
        return this.histograms.containsKey((Object)statsType);
    }

    @Override
    public boolean hasSummaryStats(org.deeplearning4j.ui.stats.api.StatsType statsType, org.deeplearning4j.ui.stats.api.SummaryType summaryType) {
        switch (summaryType) {
            case Mean: {
                return this.meanValues != null && this.meanValues.containsKey((Object)statsType);
            }
            case Stdev: {
                return this.stdevValues != null && this.stdevValues.containsKey((Object)statsType);
            }
            case MeanMagnitudes: {
                return this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)statsType);
            }
        }
        return false;
    }

    @Override
    public boolean hasDataSetMetaData() {
        return this.dataSetMetaData != null || this.metaDataClassName != null;
    }

    private Map<String, Double> mapForTypes(org.deeplearning4j.ui.stats.api.StatsType statsType, org.deeplearning4j.ui.stats.api.SummaryType summaryType) {
        switch (summaryType) {
            case Mean: {
                if (this.meanValues == null) {
                    return null;
                }
                return this.meanValues.get((Object)statsType);
            }
            case Stdev: {
                if (this.stdevValues == null) {
                    return null;
                }
                return this.stdevValues.get((Object)statsType);
            }
            case MeanMagnitudes: {
                if (this.meanMagnitudeValues == null) {
                    return null;
                }
                return this.meanMagnitudeValues.get((Object)statsType);
            }
        }
        return null;
    }

    private static void appendOrDefault(UpdateEncoder.PerParameterStatsEncoder.SummaryStatEncoder sse, String param, org.deeplearning4j.ui.stats.api.StatsType statsType, org.deeplearning4j.ui.stats.api.SummaryType summaryType, Map<String, Double> map, double defaultValue) {
        SummaryType summaryT;
        StatsType st;
        Double d = map.get(param);
        if (d == null) {
            d = defaultValue;
        }
        switch (statsType) {
            case Parameters: {
                st = StatsType.Parameters;
                break;
            }
            case Gradients: {
                st = StatsType.Gradients;
                break;
            }
            case Updates: {
                st = StatsType.Updates;
                break;
            }
            case Activations: {
                st = StatsType.Activations;
                break;
            }
            default: {
                throw new RuntimeException("Unknown stats type: " + (Object)((Object)statsType));
            }
        }
        switch (summaryType) {
            case Mean: {
                summaryT = SummaryType.Mean;
                break;
            }
            case Stdev: {
                summaryT = SummaryType.Stdev;
                break;
            }
            case MeanMagnitudes: {
                summaryT = SummaryType.MeanMagnitude;
                break;
            }
            default: {
                throw new RuntimeException("Unknown summary type: " + (Object)((Object)summaryType));
            }
        }
        sse.next().statType(st).summaryType(summaryT).value(d);
    }

    private static org.deeplearning4j.ui.stats.api.StatsType translate(StatsType statsType) {
        switch (statsType) {
            case Parameters: {
                return org.deeplearning4j.ui.stats.api.StatsType.Parameters;
            }
            case Gradients: {
                return org.deeplearning4j.ui.stats.api.StatsType.Gradients;
            }
            case Updates: {
                return org.deeplearning4j.ui.stats.api.StatsType.Updates;
            }
            case Activations: {
                return org.deeplearning4j.ui.stats.api.StatsType.Activations;
            }
        }
        throw new RuntimeException("Unknown stats type: " + (Object)((Object)statsType));
    }

    private static StatsType translate(org.deeplearning4j.ui.stats.api.StatsType statsType) {
        switch (statsType) {
            case Parameters: {
                return StatsType.Parameters;
            }
            case Gradients: {
                return StatsType.Gradients;
            }
            case Updates: {
                return StatsType.Updates;
            }
            case Activations: {
                return StatsType.Activations;
            }
        }
        throw new RuntimeException("Unknown stats type: " + (Object)((Object)statsType));
    }

    private static org.deeplearning4j.ui.stats.api.SummaryType translate(SummaryType summaryType) {
        switch (summaryType) {
            case Mean: {
                return org.deeplearning4j.ui.stats.api.SummaryType.Mean;
            }
            case Stdev: {
                return org.deeplearning4j.ui.stats.api.SummaryType.Stdev;
            }
            case MeanMagnitude: {
                return org.deeplearning4j.ui.stats.api.SummaryType.MeanMagnitudes;
            }
        }
        throw new RuntimeException("Unknown summary type: " + (Object)((Object)summaryType));
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int encodingLengthBytes() {
        UpdateEncoder ue = new UpdateEncoder();
        int bufferSize = 8 + ue.sbeBlockLength() + 16;
        int memoryUseCount = !this.memoryUsePresent ? 0 : 4 + (this.deviceCurrentBytes == null ? 0 : this.deviceCurrentBytes.length) + (this.deviceMaxBytes == null ? 0 : this.deviceMaxBytes.length);
        bufferSize += 4 + 9 * memoryUseCount;
        bufferSize += 4 + (this.performanceStatsPresent ? 32 : 0);
        bufferSize += 4;
        ArrayList<byte[]> gcStatsLabelBytes = null;
        if (this.gcStats != null && !this.gcStats.isEmpty()) {
            gcStatsLabelBytes = new ArrayList<byte[]>();
            for (int i = 0; i < this.gcStats.size(); ++i) {
                GCStats stats = this.gcStats.get(i);
                bufferSize += 12;
                byte[] byArray = SbeUtil.toBytes(true, stats.gcName);
                bufferSize += byArray.length;
                gcStatsLabelBytes.add(byArray);
            }
        }
        bufferSize += 4;
        List<String> paramNames = this.getParamNames();
        for (String string : paramNames) {
            bufferSize += 4;
            bufferSize += SbeUtil.toBytes(true, string).length;
        }
        bufferSize += 4;
        List<String> layerNames = this.getlayerNames();
        for (String string : layerNames) {
            bufferSize += 4;
            bufferSize += SbeUtil.toBytes(true, string).length;
        }
        bufferSize += 4;
        int n = paramNames.size() + layerNames.size();
        bufferSize += n * 12;
        bufferSize += this.entrySize(paramNames, org.deeplearning4j.ui.stats.api.StatsType.Parameters, org.deeplearning4j.ui.stats.api.StatsType.Gradients, org.deeplearning4j.ui.stats.api.StatsType.Updates);
        bufferSize += this.entrySize(layerNames, org.deeplearning4j.ui.stats.api.StatsType.Activations);
        bufferSize += 4;
        if (this.dataSetMetaData != null && !this.dataSetMetaData.isEmpty()) {
            for (byte[] b : this.dataSetMetaData) {
                bufferSize += 4 + b.length;
            }
        }
        byte[] byArray = SbeUtil.toBytes(true, this.sessionID);
        byte[] bTypeID = SbeUtil.toBytes(true, this.typeID);
        byte[] bWorkerID = SbeUtil.toBytes(true, this.workerID);
        bufferSize += byArray.length + bTypeID.length + bWorkerID.length;
        byte[] metaDataClassNameBytes = SbeUtil.toBytes(true, this.metaDataClassName);
        return bufferSize += metaDataClassNameBytes.length;
    }

    private int entrySize(List<String> entryNames, org.deeplearning4j.ui.stats.api.StatsType ... statsTypes) {
        int bufferSize = 0;
        for (String s : entryNames) {
            int summaryStatsCount = 0;
            for (org.deeplearning4j.ui.stats.api.StatsType statsType : statsTypes) {
                for (org.deeplearning4j.ui.stats.api.SummaryType summaryType : org.deeplearning4j.ui.stats.api.SummaryType.values()) {
                    Map<String, Double> map = this.mapForTypes(statsType, summaryType);
                    if (map == null) continue;
                    ++summaryStatsCount;
                }
            }
            bufferSize += summaryStatsCount * 10;
            int nHistogramsThisParam = 0;
            if (this.histograms != null && this.histograms.size() > 0) {
                for (Map<String, Histogram> map : this.histograms.values()) {
                    if (map == null || !map.containsKey(s)) continue;
                    ++nHistogramsThisParam;
                }
            }
            bufferSize += 25 * nHistogramsThisParam;
            int nBinCountEntries = 0;
            for (org.deeplearning4j.ui.stats.api.StatsType statsType : statsTypes) {
                Map<String, Histogram> map;
                if (this.histograms == null || !this.histograms.containsKey((Object)statsType) || (map = this.histograms.get((Object)statsType)) == null || !map.containsKey(s)) continue;
                nBinCountEntries += map.get(s).getNBins();
            }
            bufferSize += 4 * nBinCountEntries;
        }
        return bufferSize;
    }

    private List<String> getParamNames() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        if (this.learningRatesByParam != null) {
            paramNames.addAll(this.learningRatesByParam.keySet());
        }
        if (this.histograms != null) {
            this.addToSet(paramNames, this.histograms.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters));
            this.addToSet(paramNames, this.histograms.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients));
            this.addToSet(paramNames, this.histograms.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates));
        }
        if (this.meanValues != null) {
            this.addToSet(paramNames, this.meanValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters));
            this.addToSet(paramNames, this.meanValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients));
            this.addToSet(paramNames, this.meanValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates));
        }
        if (this.stdevValues != null) {
            this.addToSet(paramNames, this.stdevValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters));
            this.addToSet(paramNames, this.stdevValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients));
            this.addToSet(paramNames, this.stdevValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates));
        }
        if (this.meanMagnitudeValues != null) {
            this.addToSet(paramNames, this.meanMagnitudeValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters));
            this.addToSet(paramNames, this.meanMagnitudeValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients));
            this.addToSet(paramNames, this.meanMagnitudeValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates));
        }
        return new ArrayList<String>(paramNames);
    }

    private List<String> getlayerNames() {
        LinkedHashSet<String> layerNames = new LinkedHashSet<String>();
        if (this.histograms != null) {
            this.addToSet(layerNames, this.histograms.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations));
        }
        if (this.meanValues != null) {
            this.addToSet(layerNames, this.meanValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations));
        }
        if (this.stdevValues != null) {
            this.addToSet(layerNames, this.stdevValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations));
        }
        if (this.meanMagnitudeValues != null) {
            this.addToSet(layerNames, this.meanMagnitudeValues.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations));
        }
        return new ArrayList<String>(layerNames);
    }

    private void addToSet(Set<String> set, Map<String, ?> map) {
        if (map == null) {
            return;
        }
        set.addAll(map.keySet());
    }

    public byte[] encode() {
        byte[] bytes = new byte[this.encodingLengthBytes()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.encode((MutableDirectBuffer)buffer);
        return bytes;
    }

    public void encode(ByteBuffer buffer) {
        this.encode((MutableDirectBuffer)new UnsafeBuffer(buffer));
    }

    @Override
    public void encode(MutableDirectBuffer buffer) {
        MessageHeaderEncoder enc = new MessageHeaderEncoder();
        UpdateEncoder ue = new UpdateEncoder();
        enc.wrap(buffer, 0).blockLength(ue.sbeBlockLength()).templateId(ue.sbeTemplateId()).schemaId(ue.sbeSchemaId()).version(ue.sbeSchemaVersion());
        int offset = enc.encodedLength();
        ue.wrap(buffer, offset);
        ue.time(this.timeStamp).deltaTime(0).iterationCount(this.iterationCount).fieldsPresent().score(this.scorePresent).memoryUse(this.memoryUsePresent).performance(this.performanceStatsPresent).garbageCollection(this.gcStats != null && !this.gcStats.isEmpty()).histogramParameters(this.histograms != null && this.histograms.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters)).histogramActivations(this.histograms != null && this.histograms.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients)).histogramUpdates(this.histograms != null && this.histograms.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates)).histogramActivations(this.histograms != null && this.histograms.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations)).meanParameters(this.meanValues != null && this.meanValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters)).meanGradients(this.meanValues != null && this.meanValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients)).meanUpdates(this.meanValues != null && this.meanValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates)).meanActivations(this.meanValues != null && this.meanValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations)).meanMagnitudeParameters(this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Parameters)).meanMagnitudeGradients(this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Gradients)).meanMagnitudeUpdates(this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Updates)).meanMagnitudeActivations(this.meanMagnitudeValues != null && this.meanMagnitudeValues.containsKey((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations)).learningRatesPresent(this.learningRatesByParam != null).dataSetMetaDataPresent(this.hasDataSetMetaData());
        ue.statsCollectionDuration(this.statsCollectionDurationMs).score(this.score);
        int memoryUseCount = !this.memoryUsePresent ? 0 : 4 + (this.deviceCurrentBytes == null ? 0 : this.deviceCurrentBytes.length) + (this.deviceMaxBytes == null ? 0 : this.deviceMaxBytes.length);
        UpdateEncoder.MemoryUseEncoder mue = ue.memoryUseCount(memoryUseCount);
        if (this.memoryUsePresent) {
            int i;
            mue.next().memoryType(MemoryType.JvmCurrent).memoryBytes(this.jvmCurrentBytes).next().memoryType(MemoryType.JvmMax).memoryBytes(this.jvmMaxBytes).next().memoryType(MemoryType.OffHeapCurrent).memoryBytes(this.offHeapCurrentBytes).next().memoryType(MemoryType.OffHeapMax).memoryBytes(this.offHeapMaxBytes);
            if (this.deviceCurrentBytes != null) {
                for (i = 0; i < this.deviceCurrentBytes.length; ++i) {
                    mue.next().memoryType(MemoryType.DeviceCurrent).memoryBytes(this.deviceCurrentBytes[i]);
                }
            }
            if (this.deviceMaxBytes != null) {
                for (i = 0; i < this.deviceMaxBytes.length; ++i) {
                    mue.next().memoryType(MemoryType.DeviceMax).memoryBytes(this.deviceMaxBytes[i]);
                }
            }
        }
        UpdateEncoder.PerformanceEncoder pe = ue.performanceCount(this.performanceStatsPresent ? 1 : 0);
        if (this.performanceStatsPresent) {
            pe.next().totalRuntimeMs(this.totalRuntimeMs).totalExamples(this.totalExamples).totalMinibatches(this.totalMinibatches).examplesPerSecond((float)this.examplesPerSecond).minibatchesPerSecond((float)this.minibatchesPerSecond);
        }
        UpdateEncoder.GcStatsEncoder gce = ue.gcStatsCount(this.gcStats == null || this.gcStats.isEmpty() ? 0 : this.gcStats.size());
        ArrayList<byte[]> gcStatsLabelBytes = null;
        if (this.gcStats != null && !this.gcStats.isEmpty()) {
            gcStatsLabelBytes = new ArrayList<byte[]>();
            for (GCStats gCStats : this.gcStats) {
                byte[] byArray = SbeUtil.toBytes(true, gCStats.gcName);
                gcStatsLabelBytes.add(byArray);
            }
        }
        if (this.gcStats != null && !this.gcStats.isEmpty()) {
            int i = 0;
            for (GCStats gCStats : this.gcStats) {
                byte[] gcLabelBytes = (byte[])gcStatsLabelBytes.get(i++);
                gce.next().deltaGCCount(gCStats.deltaGCCount).deltaGCTimeMs(gCStats.deltaGCTime).putGcName(gcLabelBytes, 0, gcLabelBytes.length);
            }
        }
        List<String> paramNames = this.getParamNames();
        UpdateEncoder.ParamNamesEncoder paramNamesEncoder = ue.paramNamesCount(paramNames.size());
        for (String s : paramNames) {
            paramNamesEncoder.next().paramName(s);
        }
        List<String> list = this.getlayerNames();
        UpdateEncoder.LayerNamesEncoder lne = ue.layerNamesCount(list.size());
        for (String s : list) {
            lne.next().layerName(s);
        }
        UpdateEncoder.PerParameterStatsEncoder ppe = ue.perParameterStatsCount(paramNames.size() + list.size());
        org.deeplearning4j.ui.stats.api.StatsType[] st = new org.deeplearning4j.ui.stats.api.StatsType[]{org.deeplearning4j.ui.stats.api.StatsType.Parameters, org.deeplearning4j.ui.stats.api.StatsType.Gradients, org.deeplearning4j.ui.stats.api.StatsType.Updates};
        for (String string : paramNames) {
            ppe = ppe.next();
            float lr = 0.0f;
            if (this.learningRatesByParam != null && this.learningRatesByParam.containsKey(string)) {
                lr = this.learningRatesByParam.get(string).floatValue();
            }
            ppe.learningRate(lr);
            int summaryStatsCount = 0;
            for (org.deeplearning4j.ui.stats.api.StatsType statsType : st) {
                for (org.deeplearning4j.ui.stats.api.SummaryType summaryType : org.deeplearning4j.ui.stats.api.SummaryType.values()) {
                    Map<String, Double> map = this.mapForTypes(statsType, summaryType);
                    if (map == null || map.size() == 0) continue;
                    ++summaryStatsCount;
                }
            }
            UpdateEncoder.PerParameterStatsEncoder.SummaryStatEncoder sse = ppe.summaryStatCount(summaryStatsCount);
            for (org.deeplearning4j.ui.stats.api.StatsType statsType : st) {
                for (org.deeplearning4j.ui.stats.api.SummaryType summaryType : org.deeplearning4j.ui.stats.api.SummaryType.values()) {
                    Map<String, Double> map = this.mapForTypes(statsType, summaryType);
                    if (map == null || map.size() == 0) continue;
                    SbeStatsReport.appendOrDefault(sse, string, statsType, summaryType, map, Double.NaN);
                }
            }
            int nHistogramsThisParam = 0;
            if (this.histograms != null && this.histograms.size() > 0) {
                for (org.deeplearning4j.ui.stats.api.StatsType statsType : st) {
                    Map<String, Histogram> map = this.histograms.get((Object)statsType);
                    if (map == null || !map.containsKey(string)) continue;
                    ++nHistogramsThisParam;
                }
            }
            UpdateEncoder.PerParameterStatsEncoder.HistogramsEncoder sshe = ppe.histogramsCount(nHistogramsThisParam);
            if (nHistogramsThisParam <= 0) continue;
            for (org.deeplearning4j.ui.stats.api.StatsType statsType : st) {
                int[] binCounts;
                int nBins;
                double max;
                double min;
                Map<String, Histogram> map = this.histograms.get((Object)statsType);
                if (map == null || !map.containsKey(string)) continue;
                Histogram h = map.get(string);
                if (h == null) {
                    min = 0.0;
                    max = 0.0;
                    nBins = 0;
                    binCounts = null;
                } else {
                    min = h.getMin();
                    max = h.getMax();
                    nBins = h.getNBins();
                    binCounts = h.getBinCounts();
                }
                sshe = sshe.next().statType(SbeStatsReport.translate(statsType)).minValue(min).maxValue(max).nBins(nBins);
                UpdateEncoder.PerParameterStatsEncoder.HistogramsEncoder.HistogramCountsEncoder histCountsEncoder = sshe.histogramCountsCount(nBins);
                for (int i = 0; i < nBins; ++i) {
                    int count = binCounts == null || binCounts.length <= i ? 0 : binCounts[i];
                    histCountsEncoder.next().binCount(count);
                }
            }
        }
        for (String string : list) {
            int[] binCounts;
            int nBins;
            double max;
            double min;
            Map<String, Histogram> map;
            ppe = ppe.next();
            ppe.learningRate(0.0f);
            int summaryStatsCount = 0;
            for (org.deeplearning4j.ui.stats.api.SummaryType summaryType : org.deeplearning4j.ui.stats.api.SummaryType.values()) {
                Map<String, Double> map2 = this.mapForTypes(org.deeplearning4j.ui.stats.api.StatsType.Activations, summaryType);
                if (map2 == null || map2.size() == 0 || !map2.containsKey(string)) continue;
                ++summaryStatsCount;
            }
            UpdateEncoder.PerParameterStatsEncoder.SummaryStatEncoder sse = ppe.summaryStatCount(summaryStatsCount);
            for (org.deeplearning4j.ui.stats.api.SummaryType summaryType : org.deeplearning4j.ui.stats.api.SummaryType.values()) {
                Map<String, Double> map3 = this.mapForTypes(org.deeplearning4j.ui.stats.api.StatsType.Activations, summaryType);
                if (map3 == null || map3.size() == 0) continue;
                SbeStatsReport.appendOrDefault(sse, string, org.deeplearning4j.ui.stats.api.StatsType.Activations, summaryType, map3, Double.NaN);
            }
            int nHistogramsThisLayer = 0;
            if (this.histograms != null && this.histograms.size() > 0) {
                for (Map<String, Histogram> map4 : this.histograms.values()) {
                    if (map4 == null || !map4.containsKey(string)) continue;
                    ++nHistogramsThisLayer;
                }
            }
            UpdateEncoder.PerParameterStatsEncoder.HistogramsEncoder sshe = ppe.histogramsCount(nHistogramsThisLayer);
            if (nHistogramsThisLayer <= 0 || (map = this.histograms.get((Object)org.deeplearning4j.ui.stats.api.StatsType.Activations)) == null || !map.containsKey(string)) continue;
            Histogram h = map.get(string);
            if (h == null) {
                min = 0.0;
                max = 0.0;
                nBins = 0;
                binCounts = null;
            } else {
                min = h.getMin();
                max = h.getMax();
                nBins = h.getNBins();
                binCounts = h.getBinCounts();
            }
            sshe = sshe.next().statType(SbeStatsReport.translate(org.deeplearning4j.ui.stats.api.StatsType.Activations)).minValue(min).maxValue(max).nBins(nBins);
            UpdateEncoder.PerParameterStatsEncoder.HistogramsEncoder.HistogramCountsEncoder histCountsEncoder = sshe.histogramCountsCount(nBins);
            for (int i = 0; i < nBins; ++i) {
                int count = binCounts == null || binCounts.length <= i ? 0 : binCounts[i];
                histCountsEncoder.next().binCount(count);
            }
        }
        UpdateEncoder.DataSetMetaDataBytesEncoder metaEnc = ue.dataSetMetaDataBytesCount(this.dataSetMetaData != null ? this.dataSetMetaData.size() : 0);
        if (this.dataSetMetaData != null && !this.dataSetMetaData.isEmpty()) {
            for (byte[] b : this.dataSetMetaData) {
                metaEnc = metaEnc.next();
                UpdateEncoder.DataSetMetaDataBytesEncoder.MetaDataBytesEncoder mdbe = metaEnc.metaDataBytesCount(b.length);
                for (byte bb : b) {
                    mdbe.next().bytes(bb);
                }
            }
        }
        byte[] byArray = SbeUtil.toBytes(true, this.sessionID);
        byte[] bTypeID = SbeUtil.toBytes(true, this.typeID);
        byte[] bWorkerID = SbeUtil.toBytes(true, this.workerID);
        ue.putSessionID(byArray, 0, byArray.length);
        ue.putTypeID(bTypeID, 0, bTypeID.length);
        ue.putWorkerID(bWorkerID, 0, bWorkerID.length);
        byte[] metaDataClassNameBytes = SbeUtil.toBytes(true, this.metaDataClassName);
        ue.putDataSetMetaDataClassName(metaDataClassNameBytes, 0, metaDataClassNameBytes.length);
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public void decode(byte[] decode) {
        UnsafeBuffer buffer = new UnsafeBuffer(decode);
        this.decode((DirectBuffer)buffer);
    }

    public void decode(ByteBuffer buffer) {
        this.decode((DirectBuffer)new UnsafeBuffer(buffer));
    }

    @Override
    public void decode(DirectBuffer buffer) {
        Object a;
        MessageHeaderDecoder dec = new MessageHeaderDecoder();
        UpdateDecoder ud = new UpdateDecoder();
        dec.wrap(buffer, 0);
        int blockLength = dec.blockLength();
        int version = dec.version();
        int headerLength = dec.encodedLength();
        ud.wrap(buffer, headerLength, blockLength, version);
        this.timeStamp = ud.time();
        long deltaTime = ud.deltaTime();
        this.iterationCount = ud.iterationCount();
        UpdateFieldsPresentDecoder fpd = ud.fieldsPresent();
        this.scorePresent = fpd.score();
        this.memoryUsePresent = fpd.memoryUse();
        this.performanceStatsPresent = fpd.performance();
        boolean gc = fpd.garbageCollection();
        boolean histogramParameters = fpd.histogramParameters();
        boolean histogramUpdates = fpd.histogramUpdates();
        boolean histogramActivations = fpd.histogramActivations();
        boolean meanParameters = fpd.meanParameters();
        boolean meanUpdates = fpd.meanUpdates();
        boolean meanActivations = fpd.meanActivations();
        boolean meanMagParams = fpd.meanMagnitudeParameters();
        boolean meanMagUpdates = fpd.meanMagnitudeUpdates();
        boolean meanMagAct = fpd.meanMagnitudeActivations();
        boolean learningRatesPresent = fpd.learningRatesPresent();
        boolean metaDataPresent = fpd.dataSetMetaDataPresent();
        this.statsCollectionDurationMs = ud.statsCollectionDuration();
        this.score = ud.score();
        UpdateDecoder.MemoryUseDecoder mud = ud.memoryUse();
        ArrayList<Long> dcMem = null;
        ArrayList<Long> dmMem = null;
        for (UpdateDecoder.MemoryUseDecoder m : mud) {
            MemoryType type = m.memoryType();
            long memBytes = m.memoryBytes();
            switch (type) {
                case JvmCurrent: {
                    this.jvmCurrentBytes = memBytes;
                    break;
                }
                case JvmMax: {
                    this.jvmMaxBytes = memBytes;
                    break;
                }
                case OffHeapCurrent: {
                    this.offHeapCurrentBytes = memBytes;
                    break;
                }
                case OffHeapMax: {
                    this.offHeapMaxBytes = memBytes;
                    break;
                }
                case DeviceCurrent: {
                    if (dcMem == null) {
                        dcMem = new ArrayList<Long>();
                    }
                    dcMem.add(memBytes);
                    break;
                }
                case DeviceMax: {
                    if (dmMem == null) {
                        dmMem = new ArrayList<Long>();
                    }
                    dmMem.add(memBytes);
                    break;
                }
            }
        }
        if (dcMem != null) {
            a = new long[dcMem.size()];
            int i = 0;
            for (Long l : dcMem) {
                a[i++] = l;
            }
            this.deviceCurrentBytes = (long[])a;
        }
        if (dmMem != null) {
            a = new long[dmMem.size()];
            int i = 0;
            for (Long l : dmMem) {
                a[i++] = l;
            }
            this.deviceMaxBytes = (long[])a;
        }
        a = ud.performance().iterator();
        while (a.hasNext()) {
            UpdateDecoder.PerformanceDecoder pd = (UpdateDecoder.PerformanceDecoder)a.next();
            this.totalRuntimeMs = pd.totalRuntimeMs();
            this.totalExamples = pd.totalExamples();
            this.totalMinibatches = pd.totalMinibatches();
            this.examplesPerSecond = pd.examplesPerSecond();
            this.minibatchesPerSecond = pd.minibatchesPerSecond();
        }
        for (UpdateDecoder.GcStatsDecoder gcsd : ud.gcStats()) {
            if (this.gcStats == null) {
                this.gcStats = new ArrayList<GCStats>();
            }
            int deltaGCCount = gcsd.deltaGCCount();
            int deltaGCTimeMs = gcsd.deltaGCTimeMs();
            String gcName = gcsd.gcName();
            GCStats s = new GCStats(gcName, deltaGCCount, deltaGCTimeMs);
            this.gcStats.add(s);
        }
        UpdateDecoder.ParamNamesDecoder pnd = ud.paramNames();
        int nParams = pnd.count();
        ArrayList<String> paramNames = null;
        if (nParams > 0) {
            paramNames = new ArrayList<String>(nParams);
        }
        for (UpdateDecoder.ParamNamesDecoder pndec : pnd) {
            paramNames.add(pndec.paramName());
        }
        UpdateDecoder.LayerNamesDecoder lnd = ud.layerNames();
        int nLayers = lnd.count();
        ArrayList<String> layerNames = null;
        if (nLayers > 0) {
            layerNames = new ArrayList<String>(nLayers);
        }
        for (UpdateDecoder.LayerNamesDecoder l : lnd) {
            layerNames.add(l.layerName());
        }
        int entryNum = 0;
        for (UpdateDecoder.PerParameterStatsDecoder ppsd : ud.perParameterStats()) {
            org.deeplearning4j.ui.stats.api.StatsType st;
            boolean isParam = entryNum < nParams;
            String name = isParam ? (String)paramNames.get(entryNum) : (String)layerNames.get(entryNum - nParams);
            ++entryNum;
            float lr = ppsd.learningRate();
            if (learningRatesPresent && isParam) {
                if (this.learningRatesByParam == null) {
                    this.learningRatesByParam = new HashMap<String, Double>();
                }
                this.learningRatesByParam.put(name, Double.valueOf(lr));
            }
            for (UpdateDecoder.PerParameterStatsDecoder.SummaryStatDecoder ssd : ppsd.summaryStat()) {
                st = SbeStatsReport.translate(ssd.statType());
                org.deeplearning4j.ui.stats.api.SummaryType summaryType = SbeStatsReport.translate(ssd.summaryType());
                double value = ssd.value();
                switch (summaryType) {
                    case Mean: {
                        Map<String, Double> map;
                        if (this.meanValues == null) {
                            this.meanValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
                        }
                        if ((map = this.meanValues.get((Object)st)) == null) {
                            map = new HashMap<String, Double>();
                            this.meanValues.put(st, map);
                        }
                        map.put(name, value);
                        break;
                    }
                    case Stdev: {
                        Map<String, Double> map2;
                        if (this.stdevValues == null) {
                            this.stdevValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
                        }
                        if ((map2 = this.stdevValues.get((Object)st)) == null) {
                            map2 = new HashMap<String, Double>();
                            this.stdevValues.put(st, map2);
                        }
                        map2.put(name, value);
                        break;
                    }
                    case MeanMagnitudes: {
                        Map<String, Double> map3;
                        if (this.meanMagnitudeValues == null) {
                            this.meanMagnitudeValues = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>>();
                        }
                        if ((map3 = this.meanMagnitudeValues.get((Object)st)) == null) {
                            map3 = new HashMap<String, Double>();
                            this.meanMagnitudeValues.put(st, map3);
                        }
                        map3.put(name, value);
                    }
                }
            }
            for (UpdateDecoder.PerParameterStatsDecoder.HistogramsDecoder hd : ppsd.histograms()) {
                Map<String, Histogram> map;
                st = SbeStatsReport.translate(hd.statType());
                double min = hd.minValue();
                double max = hd.maxValue();
                int nBins = hd.nBins();
                int[] binCounts = new int[nBins];
                int i = 0;
                for (UpdateDecoder.PerParameterStatsDecoder.HistogramsDecoder.HistogramCountsDecoder hcd : hd.histogramCounts()) {
                    binCounts[i++] = (int)hcd.binCount();
                }
                Histogram h = new Histogram(min, max, nBins, binCounts);
                if (this.histograms == null) {
                    this.histograms = new HashMap<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>>();
                }
                if ((map = this.histograms.get((Object)st)) == null) {
                    map = new HashMap<String, Histogram>();
                    this.histograms.put(st, map);
                }
                map.put(name, h);
            }
        }
        for (UpdateDecoder.DataSetMetaDataBytesDecoder metaDec : ud.dataSetMetaDataBytes()) {
            if (this.dataSetMetaData == null) {
                this.dataSetMetaData = new ArrayList<byte[]>();
            }
            UpdateDecoder.DataSetMetaDataBytesDecoder.MetaDataBytesDecoder mdbd = metaDec.metaDataBytes();
            int length = mdbd.count();
            byte[] b = new byte[length];
            int i = 0;
            for (UpdateDecoder.DataSetMetaDataBytesDecoder.MetaDataBytesDecoder mdbd2 : mdbd) {
                b[i++] = mdbd2.bytes();
            }
            this.dataSetMetaData.add(b);
        }
        this.sessionID = ud.sessionID();
        this.typeID = ud.typeID();
        this.workerID = ud.workerID();
        this.metaDataClassName = ud.dataSetMetaDataClassName();
        if (!metaDataPresent) {
            this.metaDataClassName = null;
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        this.decode(bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SbeStatsReport)) {
            return false;
        }
        SbeStatsReport other = (SbeStatsReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$typeID = this.getTypeID();
        String other$typeID = other.getTypeID();
        if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        if (this.getStatsCollectionDurationMs() != other.getStatsCollectionDurationMs()) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        if (this.getJvmCurrentBytes() != other.getJvmCurrentBytes()) {
            return false;
        }
        if (this.getJvmMaxBytes() != other.getJvmMaxBytes()) {
            return false;
        }
        if (this.getOffHeapCurrentBytes() != other.getOffHeapCurrentBytes()) {
            return false;
        }
        if (this.getOffHeapMaxBytes() != other.getOffHeapMaxBytes()) {
            return false;
        }
        if (!Arrays.equals(this.getDeviceCurrentBytes(), other.getDeviceCurrentBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getDeviceMaxBytes(), other.getDeviceMaxBytes())) {
            return false;
        }
        if (this.getTotalRuntimeMs() != other.getTotalRuntimeMs()) {
            return false;
        }
        if (this.getTotalExamples() != other.getTotalExamples()) {
            return false;
        }
        if (this.getTotalMinibatches() != other.getTotalMinibatches()) {
            return false;
        }
        if (Double.compare(this.getExamplesPerSecond(), other.getExamplesPerSecond()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinibatchesPerSecond(), other.getMinibatchesPerSecond()) != 0) {
            return false;
        }
        List<GCStats> this$gcStats = this.getGcStats();
        List<GCStats> other$gcStats = other.getGcStats();
        if (this$gcStats == null ? other$gcStats != null : !((Object)this$gcStats).equals(other$gcStats)) {
            return false;
        }
        Map<String, Double> this$learningRatesByParam = this.getLearningRatesByParam();
        Map<String, Double> other$learningRatesByParam = other.getLearningRatesByParam();
        if (this$learningRatesByParam == null ? other$learningRatesByParam != null : !((Object)this$learningRatesByParam).equals(other$learningRatesByParam)) {
            return false;
        }
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> this$histograms = this.getHistograms();
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> other$histograms = other.getHistograms();
        if (this$histograms == null ? other$histograms != null : !((Object)this$histograms).equals(other$histograms)) {
            return false;
        }
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> this$meanValues = this.getMeanValues();
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> other$meanValues = other.getMeanValues();
        if (this$meanValues == null ? other$meanValues != null : !((Object)this$meanValues).equals(other$meanValues)) {
            return false;
        }
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> this$stdevValues = this.getStdevValues();
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> other$stdevValues = other.getStdevValues();
        if (this$stdevValues == null ? other$stdevValues != null : !((Object)this$stdevValues).equals(other$stdevValues)) {
            return false;
        }
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> this$meanMagnitudeValues = this.getMeanMagnitudeValues();
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> other$meanMagnitudeValues = other.getMeanMagnitudeValues();
        if (this$meanMagnitudeValues == null ? other$meanMagnitudeValues != null : !((Object)this$meanMagnitudeValues).equals(other$meanMagnitudeValues)) {
            return false;
        }
        String this$metaDataClassName = this.getMetaDataClassName();
        String other$metaDataClassName = other.getMetaDataClassName();
        if (this$metaDataClassName == null ? other$metaDataClassName != null : !this$metaDataClassName.equals(other$metaDataClassName)) {
            return false;
        }
        List<Serializable> this$dataSetMetaData = this.getDataSetMetaData();
        List<Serializable> other$dataSetMetaData = other.getDataSetMetaData();
        if (this$dataSetMetaData == null ? other$dataSetMetaData != null : !((Object)this$dataSetMetaData).equals(other$dataSetMetaData)) {
            return false;
        }
        if (this.isScorePresent() != other.isScorePresent()) {
            return false;
        }
        if (this.isMemoryUsePresent() != other.isMemoryUsePresent()) {
            return false;
        }
        return this.isPerformanceStatsPresent() == other.isPerformanceStatsPresent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SbeStatsReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $typeID = this.getTypeID();
        result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getStatsCollectionDurationMs();
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        long $jvmCurrentBytes = this.getJvmCurrentBytes();
        result = result * 59 + (int)($jvmCurrentBytes >>> 32 ^ $jvmCurrentBytes);
        long $jvmMaxBytes = this.getJvmMaxBytes();
        result = result * 59 + (int)($jvmMaxBytes >>> 32 ^ $jvmMaxBytes);
        long $offHeapCurrentBytes = this.getOffHeapCurrentBytes();
        result = result * 59 + (int)($offHeapCurrentBytes >>> 32 ^ $offHeapCurrentBytes);
        long $offHeapMaxBytes = this.getOffHeapMaxBytes();
        result = result * 59 + (int)($offHeapMaxBytes >>> 32 ^ $offHeapMaxBytes);
        result = result * 59 + Arrays.hashCode(this.getDeviceCurrentBytes());
        result = result * 59 + Arrays.hashCode(this.getDeviceMaxBytes());
        long $totalRuntimeMs = this.getTotalRuntimeMs();
        result = result * 59 + (int)($totalRuntimeMs >>> 32 ^ $totalRuntimeMs);
        long $totalExamples = this.getTotalExamples();
        result = result * 59 + (int)($totalExamples >>> 32 ^ $totalExamples);
        long $totalMinibatches = this.getTotalMinibatches();
        result = result * 59 + (int)($totalMinibatches >>> 32 ^ $totalMinibatches);
        long $examplesPerSecond = Double.doubleToLongBits(this.getExamplesPerSecond());
        result = result * 59 + (int)($examplesPerSecond >>> 32 ^ $examplesPerSecond);
        long $minibatchesPerSecond = Double.doubleToLongBits(this.getMinibatchesPerSecond());
        result = result * 59 + (int)($minibatchesPerSecond >>> 32 ^ $minibatchesPerSecond);
        List<GCStats> $gcStats = this.getGcStats();
        result = result * 59 + ($gcStats == null ? 43 : ((Object)$gcStats).hashCode());
        Map<String, Double> $learningRatesByParam = this.getLearningRatesByParam();
        result = result * 59 + ($learningRatesByParam == null ? 43 : ((Object)$learningRatesByParam).hashCode());
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> $histograms = this.getHistograms();
        result = result * 59 + ($histograms == null ? 43 : ((Object)$histograms).hashCode());
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> $meanValues = this.getMeanValues();
        result = result * 59 + ($meanValues == null ? 43 : ((Object)$meanValues).hashCode());
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> $stdevValues = this.getStdevValues();
        result = result * 59 + ($stdevValues == null ? 43 : ((Object)$stdevValues).hashCode());
        Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> $meanMagnitudeValues = this.getMeanMagnitudeValues();
        result = result * 59 + ($meanMagnitudeValues == null ? 43 : ((Object)$meanMagnitudeValues).hashCode());
        String $metaDataClassName = this.getMetaDataClassName();
        result = result * 59 + ($metaDataClassName == null ? 43 : $metaDataClassName.hashCode());
        List<Serializable> $dataSetMetaData = this.getDataSetMetaData();
        result = result * 59 + ($dataSetMetaData == null ? 43 : ((Object)$dataSetMetaData).hashCode());
        result = result * 59 + (this.isScorePresent() ? 79 : 97);
        result = result * 59 + (this.isMemoryUsePresent() ? 79 : 97);
        result = result * 59 + (this.isPerformanceStatsPresent() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SbeStatsReport(sessionID=" + this.getSessionID() + ", typeID=" + this.getTypeID() + ", workerID=" + this.getWorkerID() + ", timeStamp=" + this.getTimeStamp() + ", iterationCount=" + this.getIterationCount() + ", statsCollectionDurationMs=" + this.getStatsCollectionDurationMs() + ", score=" + this.getScore() + ", jvmCurrentBytes=" + this.getJvmCurrentBytes() + ", jvmMaxBytes=" + this.getJvmMaxBytes() + ", offHeapCurrentBytes=" + this.getOffHeapCurrentBytes() + ", offHeapMaxBytes=" + this.getOffHeapMaxBytes() + ", deviceCurrentBytes=" + Arrays.toString(this.getDeviceCurrentBytes()) + ", deviceMaxBytes=" + Arrays.toString(this.getDeviceMaxBytes()) + ", totalRuntimeMs=" + this.getTotalRuntimeMs() + ", totalExamples=" + this.getTotalExamples() + ", totalMinibatches=" + this.getTotalMinibatches() + ", examplesPerSecond=" + this.getExamplesPerSecond() + ", minibatchesPerSecond=" + this.getMinibatchesPerSecond() + ", gcStats=" + this.getGcStats() + ", learningRatesByParam=" + this.getLearningRatesByParam() + ", histograms=" + this.getHistograms() + ", meanValues=" + this.getMeanValues() + ", stdevValues=" + this.getStdevValues() + ", meanMagnitudeValues=" + this.getMeanMagnitudeValues() + ", metaDataClassName=" + this.getMetaDataClassName() + ", dataSetMetaData=" + this.getDataSetMetaData() + ", scorePresent=" + this.isScorePresent() + ", memoryUsePresent=" + this.isMemoryUsePresent() + ", performanceStatsPresent=" + this.isPerformanceStatsPresent() + ")";
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public int getStatsCollectionDurationMs() {
        return this.statsCollectionDurationMs;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public long getJvmCurrentBytes() {
        return this.jvmCurrentBytes;
    }

    @Override
    public long getJvmMaxBytes() {
        return this.jvmMaxBytes;
    }

    @Override
    public long getOffHeapCurrentBytes() {
        return this.offHeapCurrentBytes;
    }

    @Override
    public long getOffHeapMaxBytes() {
        return this.offHeapMaxBytes;
    }

    @Override
    public long[] getDeviceCurrentBytes() {
        return this.deviceCurrentBytes;
    }

    @Override
    public long[] getDeviceMaxBytes() {
        return this.deviceMaxBytes;
    }

    @Override
    public long getTotalRuntimeMs() {
        return this.totalRuntimeMs;
    }

    @Override
    public long getTotalExamples() {
        return this.totalExamples;
    }

    @Override
    public long getTotalMinibatches() {
        return this.totalMinibatches;
    }

    @Override
    public double getExamplesPerSecond() {
        return this.examplesPerSecond;
    }

    @Override
    public double getMinibatchesPerSecond() {
        return this.minibatchesPerSecond;
    }

    public List<GCStats> getGcStats() {
        return this.gcStats;
    }

    public Map<String, Double> getLearningRatesByParam() {
        return this.learningRatesByParam;
    }

    public Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> getHistograms() {
        return this.histograms;
    }

    public Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> getMeanValues() {
        return this.meanValues;
    }

    public Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> getStdevValues() {
        return this.stdevValues;
    }

    public Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> getMeanMagnitudeValues() {
        return this.meanMagnitudeValues;
    }

    public String getMetaDataClassName() {
        return this.metaDataClassName;
    }

    public boolean isScorePresent() {
        return this.scorePresent;
    }

    public boolean isMemoryUsePresent() {
        return this.memoryUsePresent;
    }

    public boolean isPerformanceStatsPresent() {
        return this.performanceStatsPresent;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setStatsCollectionDurationMs(int statsCollectionDurationMs) {
        this.statsCollectionDurationMs = statsCollectionDurationMs;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setJvmCurrentBytes(long jvmCurrentBytes) {
        this.jvmCurrentBytes = jvmCurrentBytes;
    }

    public void setJvmMaxBytes(long jvmMaxBytes) {
        this.jvmMaxBytes = jvmMaxBytes;
    }

    public void setOffHeapCurrentBytes(long offHeapCurrentBytes) {
        this.offHeapCurrentBytes = offHeapCurrentBytes;
    }

    public void setOffHeapMaxBytes(long offHeapMaxBytes) {
        this.offHeapMaxBytes = offHeapMaxBytes;
    }

    public void setDeviceCurrentBytes(long[] deviceCurrentBytes) {
        this.deviceCurrentBytes = deviceCurrentBytes;
    }

    public void setDeviceMaxBytes(long[] deviceMaxBytes) {
        this.deviceMaxBytes = deviceMaxBytes;
    }

    public void setTotalRuntimeMs(long totalRuntimeMs) {
        this.totalRuntimeMs = totalRuntimeMs;
    }

    public void setTotalExamples(long totalExamples) {
        this.totalExamples = totalExamples;
    }

    public void setTotalMinibatches(long totalMinibatches) {
        this.totalMinibatches = totalMinibatches;
    }

    public void setExamplesPerSecond(double examplesPerSecond) {
        this.examplesPerSecond = examplesPerSecond;
    }

    public void setMinibatchesPerSecond(double minibatchesPerSecond) {
        this.minibatchesPerSecond = minibatchesPerSecond;
    }

    public void setGcStats(List<GCStats> gcStats) {
        this.gcStats = gcStats;
    }

    public void setLearningRatesByParam(Map<String, Double> learningRatesByParam) {
        this.learningRatesByParam = learningRatesByParam;
    }

    public void setHistograms(Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Histogram>> histograms) {
        this.histograms = histograms;
    }

    public void setMeanValues(Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> meanValues) {
        this.meanValues = meanValues;
    }

    public void setStdevValues(Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> stdevValues) {
        this.stdevValues = stdevValues;
    }

    public void setMeanMagnitudeValues(Map<org.deeplearning4j.ui.stats.api.StatsType, Map<String, Double>> meanMagnitudeValues) {
        this.meanMagnitudeValues = meanMagnitudeValues;
    }

    public void setMetaDataClassName(String metaDataClassName) {
        this.metaDataClassName = metaDataClassName;
    }

    public void setDataSetMetaData(List<byte[]> dataSetMetaData) {
        this.dataSetMetaData = dataSetMetaData;
    }

    public void setScorePresent(boolean scorePresent) {
        this.scorePresent = scorePresent;
    }

    public void setMemoryUsePresent(boolean memoryUsePresent) {
        this.memoryUsePresent = memoryUsePresent;
    }

    public void setPerformanceStatsPresent(boolean performanceStatsPresent) {
        this.performanceStatsPresent = performanceStatsPresent;
    }

    private static class GCStats
    implements Serializable {
        private String gcName;
        private int deltaGCCount;
        private int deltaGCTime;

        public GCStats(String gcName, int deltaGCCount, int deltaGCTime) {
            this.gcName = gcName;
            this.deltaGCCount = deltaGCCount;
            this.deltaGCTime = deltaGCTime;
        }

        public String getGcName() {
            return this.gcName;
        }

        public int getDeltaGCCount() {
            return this.deltaGCCount;
        }

        public int getDeltaGCTime() {
            return this.deltaGCTime;
        }

        public void setGcName(String gcName) {
            this.gcName = gcName;
        }

        public void setDeltaGCCount(int deltaGCCount) {
            this.deltaGCCount = deltaGCCount;
        }

        public void setDeltaGCTime(int deltaGCTime) {
            this.deltaGCTime = deltaGCTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GCStats)) {
                return false;
            }
            GCStats other = (GCStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gcName = this.getGcName();
            String other$gcName = other.getGcName();
            if (this$gcName == null ? other$gcName != null : !this$gcName.equals(other$gcName)) {
                return false;
            }
            if (this.getDeltaGCCount() != other.getDeltaGCCount()) {
                return false;
            }
            return this.getDeltaGCTime() == other.getDeltaGCTime();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GCStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gcName = this.getGcName();
            result = result * 59 + ($gcName == null ? 43 : $gcName.hashCode());
            result = result * 59 + this.getDeltaGCCount();
            result = result * 59 + this.getDeltaGCTime();
            return result;
        }

        public String toString() {
            return "SbeStatsReport.GCStats(gcName=" + this.getGcName() + ", deltaGCCount=" + this.getDeltaGCCount() + ", deltaGCTime=" + this.getDeltaGCTime() + ")";
        }
    }
}

