/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.nd4j.common.collection.CompactHeapStringList;
import org.nd4j.common.util.MathUtils;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseFileIterator<T, P>
implements Iterator<T> {
    protected final List<String> list;
    protected final int batchSize;
    protected final Random rng;
    protected int[] order;
    protected int position;
    private T partialStored;
    protected P preProcessor;

    protected BaseFileIterator(@NonNull File rootDir, int batchSize, String ... validExtensions) {
        this(new File[]{rootDir}, true, new Random(), batchSize, validExtensions);
        if (rootDir == null) {
            throw new NullPointerException("rootDir is marked non-null but is null");
        }
    }

    protected BaseFileIterator(@NonNull File[] rootDirs, boolean recursive, Random rng, int batchSize, String ... validExtensions) {
        if (rootDirs == null) {
            throw new NullPointerException("rootDirs is marked non-null but is null");
        }
        this.batchSize = batchSize;
        this.rng = rng;
        this.list = new CompactHeapStringList();
        for (File rootDir : rootDirs) {
            Collection c = FileUtils.listFiles((File)rootDir, (String[])validExtensions, (boolean)recursive);
            if (c.isEmpty()) {
                throw new IllegalStateException("Root directory is empty (no files found) " + (validExtensions != null ? " (or all files rejected by extension filter)" : ""));
            }
            for (File f : c) {
                this.list.add(f.getPath());
            }
        }
        if (rng != null) {
            this.order = new int[this.list.size()];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        }
    }

    @Override
    public boolean hasNext() {
        return this.partialStored != null || this.position < this.list.size();
    }

    @Override
    public T next() {
        T next;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        if (this.partialStored != null) {
            next = this.partialStored;
            this.partialStored = null;
        } else {
            int n;
            if (this.order != null) {
                n = this.order[this.position++];
            } else {
                int n2 = this.position;
                n = n2;
                this.position = n2 + 1;
            }
            int nextIdx = n;
            next = this.load(new File(this.list.get(nextIdx)));
        }
        if (this.batchSize <= 0) {
            return next;
        }
        if (this.sizeOf(next) == (long)this.batchSize) {
            return next;
        }
        int exampleCount = 0;
        ArrayList<T> toMerge = new ArrayList<T>();
        toMerge.add(next);
        exampleCount = (int)((long)exampleCount + this.sizeOf(next));
        while (exampleCount < this.batchSize && this.hasNext()) {
            int n;
            if (this.order != null) {
                n = this.order[this.position++];
            } else {
                int n3 = this.position;
                n = n3;
                this.position = n3 + 1;
            }
            int nextIdx = n;
            next = this.load(new File(this.list.get(nextIdx)));
            exampleCount = (int)((long)exampleCount + this.sizeOf(next));
            toMerge.add(next);
        }
        Object ret = this.mergeAndStoreRemainder(toMerge);
        this.applyPreprocessor(ret);
        return (T)ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    protected T mergeAndStoreRemainder(List<T> toMerge) {
        ArrayList<T> correctNum = new ArrayList<T>();
        ArrayList<T> remainder = new ArrayList<T>();
        int soFar = 0;
        for (T t : toMerge) {
            long size = this.sizeOf(t);
            if ((long)soFar + size <= (long)this.batchSize) {
                correctNum.add(t);
                soFar = (int)((long)soFar + size);
                continue;
            }
            if (soFar < this.batchSize) {
                List<T> split = this.split(t);
                if (this.rng != null) {
                    Collections.shuffle(split, this.rng);
                }
                for (T t2 : split) {
                    if (soFar < this.batchSize) {
                        correctNum.add(t2);
                        soFar = (int)((long)soFar + this.sizeOf(t2));
                        continue;
                    }
                    remainder.add(t2);
                }
                continue;
            }
            remainder.add(t);
        }
        Object ret = this.merge(correctNum);
        if (remainder.isEmpty()) {
            this.partialStored = null;
        } else {
            try (MemoryWorkspace ws = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                this.partialStored = this.merge(remainder);
            }
        }
        return (T)ret;
    }

    public void reset() {
        this.position = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return true;
    }

    protected abstract T load(File var1);

    protected abstract long sizeOf(T var1);

    protected abstract List<T> split(T var1);

    protected abstract T merge(List<T> var1);

    protected abstract void applyPreprocessor(T var1);

    public P getPreProcessor() {
        return this.preProcessor;
    }

    public void setPreProcessor(P preProcessor) {
        this.preProcessor = preProcessor;
    }
}

