/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.utilty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ListDataSetIterator<T extends org.nd4j.linalg.dataset.DataSet>
implements DataSetIterator {
    private static final long serialVersionUID = -7569201667767185411L;
    private int curr = 0;
    private int batch = 10;
    private List<T> list;
    private DataSetPreProcessor preProcessor;

    public ListDataSetIterator(Collection<T> coll, int batch) {
        this.list = new ArrayList<T>(coll);
        this.batch = batch;
    }

    public ListDataSetIterator(Collection<T> coll) {
        this(coll, 5);
    }

    public synchronized boolean hasNext() {
        return this.curr < this.list.size();
    }

    public synchronized org.nd4j.linalg.dataset.DataSet next() {
        return this.next(this.batch);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        return ((org.nd4j.linalg.dataset.DataSet)this.list.get(0)).getFeatures().columns();
    }

    public int totalOutcomes() {
        return ((org.nd4j.linalg.dataset.DataSet)this.list.get(0)).getLabels().columns();
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public synchronized void reset() {
        this.curr = 0;
    }

    public int batch() {
        return this.batch;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        int end = this.curr + num;
        ArrayList<T> r = new ArrayList<T>();
        if (end >= this.list.size()) {
            end = this.list.size();
        }
        while (this.curr < end) {
            r.add(this.list.get(this.curr));
            ++this.curr;
        }
        org.nd4j.linalg.dataset.DataSet d = org.nd4j.linalg.dataset.DataSet.merge(r);
        if (this.preProcessor != null && !d.isPreProcessed()) {
            this.preProcessor.preProcess((DataSet)d);
            d.markAsPreProcessed();
        }
        return d;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

