/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.remote;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.DatatypeConverter;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReceiverModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(RemoteReceiverModule.class);
    private AtomicBoolean enabled = new AtomicBoolean(false);
    private StatsStorageRouter statsStorage;

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
        if (!enabled) {
            this.statsStorage = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled.get() && this.statsStorage != null;
    }

    public void setStatsStorage(StatsStorageRouter statsStorage) {
        this.statsStorage = statsStorage;
    }

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Route> getRoutes() {
        Route r = new Route("/remoteReceive", HttpMethod.POST, (path, rc) -> this.receiveData((RoutingContext)rc));
        return Collections.singletonList(r);
    }

    @Override
    public void reportStorageEvents(Collection<StatsStorageEvent> events) {
    }

    @Override
    public void onAttach(StatsStorage statsStorage) {
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
    }

    @Override
    public List<I18NResource> getInternationalizationResources() {
        return Collections.emptyList();
    }

    private void receiveData(RoutingContext rc) {
        if (!this.enabled.get()) {
            rc.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end("UI server remote listening is currently disabled. Use UIServer.getInstance().enableRemoteListener()");
            return;
        }
        if (this.statsStorage == null) {
            rc.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("UI Server remote listener: no StatsStorage instance is set/available to store results");
            return;
        }
        JsonObject jo = rc.getBodyAsJson();
        Map map = jo.getMap();
        String type = (String)map.get("type");
        String dataClass = (String)map.get("class");
        String data = (String)map.get("data");
        if (type == null || dataClass == null || data == null) {
            log.warn("Received incorrectly formatted data from remote listener (has type = " + (type != null) + ", has data class = " + (dataClass != null) + ", has data = " + (data != null) + ")");
            rc.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Received incorrectly formatted data");
            return;
        }
        switch (type.toLowerCase()) {
            case "metadata": {
                StorageMetaData meta = this.getMetaData(dataClass, data);
                if (meta == null) break;
                this.statsStorage.putStorageMetaData(meta);
                break;
            }
            case "staticinfo": {
                Persistable staticInfo = this.getPersistable(dataClass, data);
                if (staticInfo == null) break;
                this.statsStorage.putStaticInfo(staticInfo);
                break;
            }
            case "update": {
                Persistable update = this.getPersistable(dataClass, data);
                if (update == null) break;
                this.statsStorage.putUpdate(update);
                break;
            }
        }
        rc.response().end();
    }

    private StorageMetaData getMetaData(String dataClass, String content) {
        StorageMetaData meta;
        try {
            Class<?> c = Class.forName(dataClass);
            if (!StorageMetaData.class.isAssignableFrom(c)) {
                log.warn("Skipping invalid remote data: class {} in not an instance of {}", (Object)dataClass, (Object)StorageMetaData.class.getName());
                return null;
            }
            meta = (StorageMetaData)c.newInstance();
        }
        catch (Exception e) {
            log.warn("Skipping invalid remote data: exception encountered for class {}", (Object)dataClass, (Object)e);
            return null;
        }
        try {
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)content);
            meta.decode(bytes);
        }
        catch (Exception e) {
            log.warn("Skipping invalid remote UI data: exception encountered when deserializing data", (Throwable)e);
            return null;
        }
        return meta;
    }

    private Persistable getPersistable(String dataClass, String content) {
        Persistable p;
        try {
            Class<?> c = Class.forName(dataClass);
            if (!Persistable.class.isAssignableFrom(c)) {
                log.warn("Skipping invalid remote data: class {} in not an instance of {}", (Object)dataClass, (Object)Persistable.class.getName());
                return null;
            }
            p = (Persistable)c.newInstance();
        }
        catch (Exception e) {
            log.warn("Skipping invalid remote UI data: exception encountered for class {}", (Object)dataClass, (Object)e);
            return null;
        }
        try {
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)content);
            p.decode(bytes);
        }
        catch (Exception e) {
            log.warn("Skipping invalid remote data: exception encountered when deserializing data", (Throwable)e);
            return null;
        }
        return p;
    }
}

