/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class VGG19
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private VGG19() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/vgg19_dl4j_inference.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 2782932419L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        ComputationGraphConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).activation(Activation.RELU).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).graphBuilder().addInputs(new String[]{"in"}).layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nIn(this.inputShape[0])).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"in"}).layer(1, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"0"}).layer(2, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build(), new String[]{"1"}).layer(3, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"2"}).layer(4, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"3"}).layer(5, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build(), new String[]{"4"}).layer(6, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"5"}).layer(7, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"6"}).layer(8, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"7"}).layer(9, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"8"}).layer(10, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build(), new String[]{"9"}).layer(11, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"10"}).layer(12, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"11"}).layer(13, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"12"}).layer(14, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"13"}).layer(15, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build(), new String[]{"14"}).layer(16, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"15"}).layer(17, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"16"}).layer(18, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"17"}).layer(19, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"18"}).layer(20, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build(), new String[]{"19"}).layer(21, (Layer)((DenseLayer.Builder)new DenseLayer.Builder().nOut(4096)).build(), new String[]{"20"}).layer(22, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).name("output")).nOut(this.numClasses)).activation(Activation.SOFTMAX)).build(), new String[]{"21"}).setOutputs(new String[]{"22"}).setInputTypes(new InputType[]{InputType.convolutionalFlat((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])}).build();
        return conf;
    }

    public ComputationGraph init() {
        ComputationGraph network = new ComputationGraph(this.conf());
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Nesterovs();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    public static VGG19Builder builder() {
        return new VGG19Builder();
    }

    public VGG19(long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class VGG19Builder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        VGG19Builder() {
        }

        public VGG19Builder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public VGG19Builder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public VGG19Builder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public VGG19Builder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public VGG19Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public VGG19Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public VGG19Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public VGG19 build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = VGG19.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = VGG19.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = VGG19.$default$numClasses();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = VGG19.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = VGG19.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = VGG19.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = VGG19.$default$cudnnAlgoMode();
            }
            return new VGG19(seed, inputShape, numClasses, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "VGG19.VGG19Builder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

