/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.models.embeddings.word2vec;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class NegativeHolder
implements Serializable {
    private static NegativeHolder ourInstance = new NegativeHolder();
    private volatile INDArray syn1Neg;
    private volatile INDArray table;
    private transient AtomicBoolean wasInit = new AtomicBoolean(false);
    private transient VocabCache<VocabWord> vocab;

    public static NegativeHolder getInstance() {
        return ourInstance;
    }

    private NegativeHolder() {
    }

    public synchronized void initHolder(@NonNull VocabCache<VocabWord> vocabCache, double[] expTable, int layerSize) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        if (!this.wasInit.get()) {
            this.vocab = vocabCache;
            this.syn1Neg = Nd4j.zeros((int[])new int[]{vocabCache.numWords(), layerSize});
            this.makeTable(Math.max(expTable.length, 100000), 0.75);
            this.wasInit.set(true);
        }
    }

    protected void makeTable(int tableSize, double power) {
        String word2;
        int vocabSize = this.vocab.numWords();
        this.table = Nd4j.create((DataType)DataType.FLOAT, (long[])new long[]{tableSize});
        double trainWordsPow = 0.0;
        for (String word2 : this.vocab.words()) {
            trainWordsPow += Math.pow(this.vocab.wordFrequency(word2), power);
        }
        int wordIdx = 0;
        word2 = this.vocab.wordAtIndex(wordIdx);
        double d1 = Math.pow(this.vocab.wordFrequency(word2), power) / trainWordsPow;
        for (int i = 0; i < tableSize; ++i) {
            this.table.putScalar((long)i, wordIdx);
            double mul = (double)i * 1.0 / (double)tableSize;
            if (!(mul > d1)) continue;
            if (wordIdx < vocabSize - 1) {
                ++wordIdx;
            }
            word2 = this.vocab.wordAtIndex(wordIdx);
            String wordAtIndex = this.vocab.wordAtIndex(wordIdx);
            if (word2 == null) continue;
            d1 += Math.pow(this.vocab.wordFrequency(wordAtIndex), power) / trainWordsPow;
        }
    }

    public INDArray getSyn1Neg() {
        return this.syn1Neg;
    }

    public INDArray getTable() {
        return this.table;
    }
}

