/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.models.embeddings.word2vec;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class VocabHolder
implements Serializable {
    private static VocabHolder ourInstance = new VocabHolder();
    private Map<VocabWord, INDArray> indexSyn0VecMap = new ConcurrentHashMap<VocabWord, INDArray>();
    private Map<Integer, INDArray> pointSyn1VecMap = new ConcurrentHashMap<Integer, INDArray>();
    private HashSet<Long> workers = new LinkedHashSet<Long>();
    private AtomicLong seed = new AtomicLong(0L);
    private AtomicInteger vectorLength = new AtomicInteger(0);

    public static VocabHolder getInstance() {
        return ourInstance;
    }

    private VocabHolder() {
    }

    public void setSeed(long seed, int vectorLength) {
        this.seed.set(seed);
        this.vectorLength.set(vectorLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray getSyn0Vector(Integer wordIndex, VocabCache<VocabWord> vocabCache) {
        VocabWord word;
        if (!this.workers.contains(Thread.currentThread().getId())) {
            this.workers.add(Thread.currentThread().getId());
        }
        if (!this.indexSyn0VecMap.containsKey(word = (VocabWord)vocabCache.elementAtIndex(wordIndex.intValue()))) {
            VocabHolder vocabHolder = this;
            synchronized (vocabHolder) {
                if (!this.indexSyn0VecMap.containsKey(word)) {
                    this.indexSyn0VecMap.put(word, this.getRandomSyn0Vec(this.vectorLength.get(), wordIndex.intValue()));
                }
            }
        }
        return this.indexSyn0VecMap.get(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray getSyn1Vector(Integer point) {
        if (!this.pointSyn1VecMap.containsKey(point)) {
            VocabHolder vocabHolder = this;
            synchronized (vocabHolder) {
                if (!this.pointSyn1VecMap.containsKey(point)) {
                    this.pointSyn1VecMap.put(point, Nd4j.zeros((int[])new int[]{1, this.vectorLength.get()}));
                }
            }
        }
        return this.pointSyn1VecMap.get(point);
    }

    private INDArray getRandomSyn0Vec(int vectorLength, long lseed) {
        return Nd4j.rand((int[])new int[]{1, vectorLength}, (long)(lseed * this.seed.get())).subi((Number)0.5).divi((Number)vectorLength);
    }

    public Iterable<Map.Entry<VocabWord, INDArray>> getSplit(VocabCache<VocabWord> vocabCache) {
        HashSet<Map.Entry<VocabWord, INDArray>> set = new HashSet<Map.Entry<VocabWord, INDArray>>();
        int cnt = 0;
        for (Map.Entry<VocabWord, INDArray> entry : this.indexSyn0VecMap.entrySet()) {
            set.add(entry);
            if (++cnt <= 10) continue;
            break;
        }
        System.out.println("Returning set: " + set.size());
        return set;
    }
}

