/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.nd4j.common.primitives.Counter;

public class FoldBetweenPartitionFunction
implements Function2<Integer, Iterator<AtomicLong>, Iterator<Long>> {
    private Broadcast<Counter<Integer>> broadcastedMaxPerPartitionCounter;

    public FoldBetweenPartitionFunction(Broadcast<Counter<Integer>> broadcastedMaxPerPartitionCounter) {
        this.broadcastedMaxPerPartitionCounter = broadcastedMaxPerPartitionCounter;
    }

    public Iterator<Long> call(Integer ind, Iterator<AtomicLong> partition) throws Exception {
        int sumToAdd = 0;
        Counter maxPerPartitionCounterInScope = (Counter)this.broadcastedMaxPerPartitionCounter.value();
        if (ind != 0) {
            for (int i = 0; i < ind; ++i) {
                sumToAdd = (int)((double)sumToAdd + maxPerPartitionCounterInScope.getCount((Object)i));
            }
        }
        ArrayList<Long> itemsAddedToList = new ArrayList<Long>();
        while (partition.hasNext()) {
            itemsAddedToList.add(partition.next().get() + (long)sumToAdd);
        }
        return itemsAddedToList.iterator();
    }
}

