/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.text.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.common.primitives.Pair;

public class WordsListToVocabWordsFunction
implements Function<Pair<List<String>, AtomicLong>, List<VocabWord>> {
    Broadcast<VocabCache<VocabWord>> vocabCacheBroadcast;

    public WordsListToVocabWordsFunction(Broadcast<VocabCache<VocabWord>> vocabCacheBroadcast) {
        this.vocabCacheBroadcast = vocabCacheBroadcast;
    }

    public List<VocabWord> call(Pair<List<String>, AtomicLong> pair) throws Exception {
        List wordsList = (List)pair.getFirst();
        ArrayList<VocabWord> vocabWordsList = new ArrayList<VocabWord>();
        VocabCache vocabCache = (VocabCache)this.vocabCacheBroadcast.getValue();
        for (String s : wordsList) {
            VocabWord word;
            if (vocabCache.containsWord(s)) {
                word = (VocabWord)vocabCache.wordFor(s);
                vocabWordsList.add(word);
                continue;
            }
            if (!vocabCache.containsWord("UNK")) continue;
            word = (VocabWord)vocabCache.wordFor("UNK");
            vocabWordsList.add(word);
        }
        return vocabWordsList;
    }
}

