/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.indexer.HalfIndexer;

public class HalfBufferIndexer
extends HalfIndexer {
    protected ShortBuffer buffer;

    public HalfBufferIndexer(ShortBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public HalfBufferIndexer(ShortBuffer buffer, long ... sizes) {
        this(buffer, sizes, HalfBufferIndexer.strides(sizes));
    }

    public HalfBufferIndexer(ShortBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public float get(long i) {
        return HalfBufferIndexer.toFloat(this.buffer.get((int)i));
    }

    @Override
    public HalfIndexer get(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfBufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + n));
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return HalfBufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j));
    }

    @Override
    public HalfIndexer get(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfBufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n));
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return HalfBufferIndexer.toFloat(this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k));
    }

    @Override
    public float get(long ... indices) {
        return HalfBufferIndexer.toFloat(this.buffer.get((int)this.index(indices)));
    }

    @Override
    public HalfIndexer get(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfBufferIndexer.toFloat(this.buffer.get((int)this.index(indices) + n));
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, float h) {
        this.buffer.put((int)i, (short)HalfBufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public HalfIndexer put(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, (short)HalfBufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, float h) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, (short)HalfBufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, (short)HalfBufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, long k, float h) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, (short)HalfBufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public HalfIndexer put(long[] indices, float h) {
        this.buffer.put((int)this.index(indices), (short)HalfBufferIndexer.fromFloat(h));
        return this;
    }

    @Override
    public HalfIndexer put(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, (short)HalfBufferIndexer.fromFloat(h[offset + n]));
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

